#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "меньше секунды",
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Path::Tiny;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;

$log->out('START');

my $data_path = my_inc::path('./20160726_restore_hidden_status_on_users.data');

my @uids = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");

for my $shard (ppc_shards()) {
    my $current = get_hash_sql(PPC(shard => $shard), ['SELECT uid, hidden FROM users', WHERE => {uid => \@uids}]);
    $log->out({shard => $shard, current => $current});
    my $res = do_update_table(PPC(shard => $shard), 'users', {hidden => 'No'}, where => {uid => \@uids});
    $log->out({shard => $shard, updated_rows => $res});
}

$log->out('FINISH');

