#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько секунд',
  comment => 'Проставляем галочку неотключения общего счета клииентам, у которых она уже стоит в Балансе',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my @CUSTOMERS_WITH_LOCK = (
    'imedia-alorm',
    'imedia-brio-finance',
    'imedia-mobiprof',
    'imedia-mskritual',
    'imedia-alser',
    'i-media-baon',
    'i-media-baon-2',
    'imedia-englishfirstef',
    'i-media-english-language',
    'imedia-forkom',
    'imedia-interalyans',
    'imedia-kgk-global',
    'imedia-lecafeier',
    'imedia-mtset',
    'i-media-naim',
    'imedia-prof-control',
    'imedia-rumag',
    'imedia-tinkoffinsurance',
    'imedia-mb-belyaevo-2',
    'imedia-zvezdanevi',
    'imedia-alibra',
    'imedia-alibra-ekb',
    'imedia-alibra-kz',
    'imedia-mastmed',
    'imedia-creditnyiadvokat',
    'imedia-autocentr',
    'imedia-doors',
    'imedia-onlime-rt',
    'imedia-portfeli-sumki',
    'imedia-rbauto-new',
    'sokolof-74',
    'imedia-b2b-rt',
    'imedia-homeme',
    'imedia-cifrocity',
    'imedia-moskaljans',
    'imedia-sokol',
    'imedia-fabrikapremium',
    'imedia-yangee',
    'gmotors2015',
    'imedia-fitness',
    'imedia-gmgen',
    'imedia-stolplit-ru',
    'imedia-technonikol',
    'imedia-technonikol-2',
    'imedia-traktat',
    'imedia-zdorovie',
    'imedia-ksk',
    'imedia-sewingworld',
    'imedia-rl-pansion',
    'imedia-aconit',
    'imedia-avanta',
    'imedia-cloudlite1',
    'imedia-dostupokna',
    'imedia-kromadom',
    'imedia-mvp',
    'imedia-termomir',
    'imedia-avtogermes',
    'imedia-createlook',
    'imedia-evromedservis',
    'imedia-zenit',
    'imedia-walatovsky',
    'teplolyux-new',
    'imedia-agrotreding',
    'imedia-printoteka',
    'imedia-sgs-holding',
    'imedia-standard-g',
    'imedia-4kapli',
    'imedia-camping',
    'imedia-lkmpolymer',
    'imedia-citilink',
    'imedia-citilink2',
    'imedia-citilink-chlb',
    'imedia-citilink-ekb',
    'imedia-citilink-krasn',
    'imedia-citilink-krd',
    'imedia-citilink-kzn',
    'imedia-citilink-nnov',
    'imedia-citilink-penza',
    'imedia-citilink-perm',
    'imedia-citilink-rnd',
    'imedia-citilink-smr',
    'imedia-citilink-spb',
    'imedia-citilink-srt',
    'imedia-citilink-stav',
    'imedia-citilink-tlt',
    'imedia-citilink-tula',
    'imedia-citilink-vlg',
    'imedia-citilink-vlzh',
    'imedia-citilink-vrnzh',
    'imedia-citilink-yar',
    'www-kupivip-ru',
    'www-kupivip-ru-2',
    'www-kupivip-ru-3',
    'www-kupivip-ru-4',
    'www-kupivip-ru-10',
    'www-kupivip-ru-5',
    'www-kupivip-ru-6',
    'www-kupivip-ru-7',
    'www-kupivip-ru-9',
    'www-kupivip-ru-8',
    'imedia-angelball',
    'imedia-instrument-ms',
    'imedia-kvartadom',
    'imedia-marketakb',
    'imedia-stankomasch',
    'imedia-esky',
    'imedia-greenlandya',
    'imedia-idcollection',
    'imedia-myparker',
    'imedia-myvictorinox',
    'imedia-rss',
    'imedia-sd-media',
    'imedia-vivaset',
    'imedia-wilgood',
    'otto-sea',
    'imedia-fitnes',
    'imedia-fkmotors',
    'imedia-hardcandy',
    'imedia-quelle',
    'imedia-wilgood2',
    'imedia-4sis',
    'imedia-communigate',
    'imedia-kokirov',
    'imedia-ust',
    'imedia-medaliprologo',
    'imedia-sportgrad',
    'imedia-himkimed1',
    'imedia-kardinal1',
    'imedia-kostis',
    'imedia-mtservice',
    'imedia-shad',
    'imedia-shop365',
    'imedia-skylift',
    'imedia-tk-konstruktor',
    'skoda-ventus',
    'imedia-alvek',
    'imedia-bmo',
    'imedia-gmt-clinic',
    'imedia-kalitniki-catering',
    'imedia-krosto',
    'imedia-natcredit',
    'imedia-october',
    'imedia-rezidenzia',
    'imedia-babysecret',
    'imedia-broker',
    'i-media-irr',
    'i-media-irr-building',
    'i-media-irr-by',
    'i-media-irr-cars',
    'i-media-irr-kz',
    'i-media-irr-real-estate',
    'imedia-job',
    'imedia-job-kz',
    'imedia-prostocredit',
    'imedia-sodis',
    'mytoys-ru',
    'imedia-5kv',
    'imedia-istra-dolina',
    'imedia-rekareka',
    'imedia-carmenta',
    'imedia-chisto',
    'imedia-intervesp-stanki',
    'imedia-obrazshop',
    'imedia-shop',
    'ktdsk1ko',
    'imedia-autonomy-lada-new',
    'imedia-imeretinka',
    'imedia-bnp',
    'imedia-e96',
    'imedia-e96-chlb',
    'imedia-e96-miass',
    'imedia-e96-novosib',
    'imedia-e96-omsk',
    'imedia-e96-perm',
    'imedia-e96-samara',
    'imedia-e96-tumen',
    'imedia-e96-yfa2',
    'imedia-klassikacourier',
    'imedia-bioman',
    'imedia-svetoteka',
    'imedia-taxichaika',
    'imedia-vinzor',
    'imedia-juraddress',
    'imedia-loresconsulti',
    'imedia-onona',
    'imedia-velikan',
    'imedia-zdravcityru',
    'obi-reklama',
    'imedia-oknarosta',
    'imedia-line24',
    'imedia-osmo',
    'imedia-hc',
    'imedia-ooorusflag',
    'imedia-peterhost',
    'imedia-rbk',
    'imedia-rucentr',
    'imedia-rusflag',
    'imedia-sweb'
);

sub set_sent_state {
    my ($shard, $logins) = @_;
    if (! defined $shard) {
        $log->out("Logins without shards @$logins");
        return;
    }
    my $prefix_guard = $log->msg_prefix_guard("[shard_$shard]");

    $log->out('Fetching ClientIDs for clients');
    my $client_ids = get_one_column_sql(PPC(shard => $shard),
        ["SELECT ClientID FROM users", WHERE => {login => $logins}]);

    $log->out('Inserting data');
    my @data_to_insert = map {[$_, 'sent']} @$client_ids;
    my $count = do_mass_insert_sql(PPC(shard => $shard),
        'INSERT INTO wallet_campaigns_lock (ClientID, state) values %s ON DUPLICATE KEY UPDATE state="sent"', \@data_to_insert);
    $log->out("Inserted $count entries");
}

$log->out('START');

foreach_shard('login' => \@CUSTOMERS_WITH_LOCK, with_undef_shard => 1, \&set_sent_state);

$log->out('FINISH');
