#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'несколько минут',
  comment => 'заменяем в campaigns.currency NULL на YND_FIXED',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw(chunks);
use Yandex::Retry;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);

my $SLEEP_COEF = 1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out('Fetching cids to replace NULL with YND_FIXED');
    my $cids = get_one_column_sql(PPC(shard => $shard), ['
        SELECT cid
        FROM campaigns
        WHERE currency IS NULL
    ']);
    $log->out('Got ' . scalar(@$cids) . ' cids');
    if (@$cids) {
        for my $cids_chunk (chunks $cids, 1_000) {
            my $relax = relaxed_guard(times => $SLEEP_COEF);

            my $cids_str = join(',', @$cids_chunk);
            $log->out("Updating cids $cids_str");
            my $affected_rows_cnt = do_update_table(PPC(shard => $shard), 'campaigns', {currency => 'YND_FIXED', LastChange__dont_quote => 'LastChange'}, where => {cid => $cids_chunk, currency__is_null => 1});
            $log->out("Affected $affected_rows_cnt rows");
        }
    }
}

$log->out('FINISH');
