#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'порядка 10 часов',
  comment => 'Удаляем из users_options.options неактуальные данные. Можно перезапускать. Умеет --sleep-coef N чтобы меньше грузить базу.',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use User ();
use Yandex::Clone qw/yclone/;
use YAML ();

my $SLEEP_COEF = 1;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
);

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out('Fetching uids data to clean');
    my $data = get_all_sql(PPC(shard => $shard), ['
        SELECT uid, options
        FROM users_options
        WHERE options LIKE "%autobroker:%"
           OR options LIKE "%-low-ctr%"
           OR options LIKE "%initial_country:%"
           OR options LIKE "%initial_currency:%"
    ']);
    $log->out('Got ' . scalar(@$data) . ' uids to clean');
    if (@$data) {
        for my $row (@$data) {
            my $relax = relaxed_guard(times => $SLEEP_COEF);

            my $uid = $row->{uid};
            my $raw_old_options = $row->{options};
            $log->out({uid => $uid, old_options => $raw_old_options});
            my $old_options = User::parse_user_options($raw_old_options);
            my $new_options = yclone($old_options);

            for my $field (qw(autobroker initial_country initial_currency)) {
                delete $new_options->{$field};
            }

            if (exists $new_options->{toggle} && $new_options->{toggle}) {
                my @toggle = split /\|/, $new_options->{toggle};
                @toggle = grep { !/-low-ctr$/ } @toggle;
                if (@toggle) {
                    $new_options->{toggle} = join('|', @toggle);
                } else {
                    delete $new_options->{toggle};
                }
            }

            my $raw_new_options = (%$new_options) ? YAML::Dump($new_options) : undef;
            $log->out({uid => $uid, new_options => $raw_new_options});
            my $updated_rows_cnt = do_update_table(PPC(shard => $shard), 'users_options', {options => $raw_new_options}, where => {uid => $uid, options => $raw_old_options});
            $log->out({uid => $uid, updated_rows_cnt => $updated_rows_cnt});
        }
    }
}

$log->out('FINISH');
