#!/usr/bin/perl

=head1 DEPLOY

# approved by pankovpv
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'полминуты',
  comment => 'удаляем записи из bs_export_specials для несуществующих кампаний',
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out('Fetching cids to clean');
    my $cids = get_one_column_sql(PPC(shard => $shard), ['
        SELECT s.cid
        FROM bs_export_specials s
        LEFT JOIN campaigns c ON s.cid = c.cid
        WHERE c.cid IS NULL
    ']);
    $log->out('Got ' . scalar(@$cids) . ' campaigns to clean bs_export_specials for');
    if ($cids && @$cids) {
        my $deleted_rows_cnt = do_delete_from_table(PPC(shard => $shard), 'bs_export_specials', where => {cid => $cids});
        $log->out('Deleted ' . ($deleted_rows_cnt + 0) . ' rows');
    }
}

$log->out('FINISH');

