#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "предположительно несколько минут",
  comment => "сначала привезти файл с номерами заказов, запускать так: 20160819_fix_old_camps_stat.pl < <файл>"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Validate;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');

my $i =0;

while (my $l = <>) {
    $i++;
    chomp $l;
    my ($shard, $orderid) = split (/\s+/, $l);
    unless (is_valid_id($orderid)) {
        $log->out("$i invalid orderid: $orderid");
        next;
    }
    $log->out("$i going to process orderid $orderid");
    eval {
        do_sql(PPCSTAT(shard => $shard), "drop table ppcstat_data.order_stat_$orderid");
    };
    if ($@) {
        $log->out("can't drop table ppcstat_data.order_stat_$orderid ", $@);
    }
    eval {
        do_sql(PPCSTAT(shard => $shard), "drop table ppcstat_data.order_stat_small_$orderid");
    };
    if ($@) {
        $log->out("can't drop table ppcstat_data.order_stat_small_$orderid ", $@);
    }
    do_sql(PPCSTAT(shard => $shard), "update order_stat_info set needCompleteSync = 'Yes' where orderid = ?", $orderid);
    $log->out("SUCCESS $orderid");
}

$log->out('FINISH');