#!/usr/bin/perl


=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "предположительно несколько минут",
  comment => "сначала привезти файл с номерами креативов, запускать так: 20160825_arch_creative_banners.pl <файл>"
}

=cut

use my_inc '..';

use Direct::Modern;
use File::Slurp;
use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::ListUtils qw/chunks/;
use Direct::Validation::Banners qw/validate_suspend_banners validate_archive_banners/;
use List::MoreUtils qw/uniq/;
use Yandex::DBShards;
use Direct::Banners;
use Direct::Campaigns;
use JSON;
use RBAC2::Extended;
use MailNotification;

die "unknown file" unless -e $ARGV[0];

my @creatives = map {chomp; [split /\s+/, $_]->[1]}  read_file($ARGV[0]);

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton(1);
MailNotification::save_UID_rbac(1, $rbac);

foreach_shard creative_id => \@creatives, sub {

    my ($shard, $ids) = @_;

    my $ids_in = join ",", @$ids;
    my $bids = get_one_column_sql(PPC(shard => $shard),
                                  "SELECT ban.bid
                                  FROM 
                                    banners ban 
                                    JOIN (
                                        SELECT 
                                          b.pid,
                                          COUNT(DISTINCT b.bid) AS total,
                                          COUNT(DISTINCT IF(b.statusArch = 'Yes' AND bp.creative_id NOT IN ($ids_in), b.bid, NULL)) AS arch,
                                          COUNT(DISTINCT IF(b.statusArch = 'No' AND bp.creative_id IN ($ids_in), b.bid, NULL)) AS active
                                        FROM (select distinct pid from banners_performance where creative_id IN ($ids_in)) AS gr
                                          JOIN banners b ON b.pid = gr.pid
                                          JOIN banners_performance bp USING(bid) 
                                        GROUP BY b.pid
                                        HAVING total = arch + active AND arch > 0) AS t ON ban.pid = t.pid
                                  WHERE
                                    ban.statusArch = 'No'");

    $log->msg_prefix("[shard $shard]");
    $log->out(sprintf "found %d banners", scalar @$bids);

    my $banners = Direct::Banners->get_by(banner_id => $bids)->items;
    my @cids = uniq map { $_->campaign_id } @$banners;
    my $campaigns = Direct::Campaigns->get_by(campaign_id => \@cids)->items_by('id');

    for my $chunk (chunks $banners, 500) {
        my @to_archive;
        for my $banner (@$chunk) {
            $log->out("process bid " . $banner->id);
            $banner->campaign($campaigns->{$banner->campaign_id});
            my $vr = validate_suspend_banners([$banner]);
            unless ($vr->is_valid) {
                $log->out(sprintf "bid %d suspend errors: %s", $banner->id, join ";", @{$vr->get_error_texts});
                next;
            }

            $banner->status_show('No');
            my $vr_a = validate_archive_banners([$banner]);
            unless ($vr_a->is_valid) {
                $log->out(sprintf "bid %d archive errors: %s", $banner->id, join ";", @{$vr_a->get_error_descriptions});
                next;
            }
            $log->out("archive banner " . $banner->id);
            $log->out("banner state: " . to_json($banner->to_hash));
            push @to_archive, $banner;
        }

        if (@to_archive) {
            my $banners = Direct::Banners->new(items => \@to_archive);
            # 1 - is UID
            $banners->suspend(1);
            $banners->archive(1);
        }
    }
};

$log->out('FINISH');
