#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 час',
  comment => q/
    можно перезапускать;
    проверить результат (должно быть 0):
      SELECT count(*) FROM banners_performance WHERE cid=0 OR banner_creative_id=0;
  /,
}

=cut

use Direct::Modern;

use my_inc '..';

use Yandex::DBTools;
use Yandex::DBShards;

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use Yandex::ListUtils qw/chunks/;

$log->out('START');

for my $shard (ppc_shards()) {

    $log->out("updating shard: $shard");

    my $items = get_all_sql(PPC(shard => $shard), [
            'SELECT bid, b.cid
            FROM banners_performance bp
            JOIN banners b USING(bid)',
            WHERE => { _OR => { 'bp.cid' => 0, 'bp.banner_creative_id' => 0 } },
        ]);

    $log->out(sprintf "Found %d records to update", scalar @$items);

    for my $chunk (chunks $items, 1_000) {
        my $new_ids = get_new_id_multi('banner_creative_id', scalar @$chunk);
        my $updated = do_sql(PPC(shard => $shard), [
                'UPDATE banners_performance bp JOIN banners b USING(bid)',
                'SET bp.cid = ', sql_case(bid => +{map {($_->{bid} => $_->{cid})} @$chunk}),
                ', bp.banner_creative_id = ', sql_case(bid => +{map {($_->{bid} => shift @$new_ids)} @$chunk}),
                ', bp.statusModerate = IF(b.statusModerate="New", "New", "Yes")',
                WHERE => {bid => [map {$_->{bid}} @$chunk]},
            ]);

        $log->out("Updated $updated records");
    }
}

$log->out('FINISH');

