#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => '1 час',
  comment => 'Минус слова на кампанию: заменяем старый формат минус слов (разделение по пробелам) на новый (json)
              Можно перезапускать с параметром sleep-coef

              В случае осложнений запустить эту же миграцию с флагом --revert
              Это поменяет формат данных в БД на старый. Также следует сообщить релиз менеджеру, eboguslavskaya@ и hrustyashko@
              Пример запуска при осложнениях:
              20160830_campaigns_minus_words_from_str_to_json.pl --shard=7 --revert

              ',
}

=cut


use Direct::Modern;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

use Yandex::DBTools;
use Yandex::DBShards qw/get_shard/;
use Yandex::Retry qw/relaxed/;
use Yandex::Validate qw/is_valid_id/;
use Yandex::ListUtils qw/chunks/;
use MinusWordsTools;

my $SLEEP_TIME_COEF = 1;
my $CID;
my $SHARD;
my $REVERT = 0;

extract_script_params(
    'cid=i' => \$CID,
    'shard=i' => \$SHARD,
    'sleep-coef' => \$SLEEP_TIME_COEF,
    'revert' =>  \$REVERT,
);
$log->out('START');

my $only_shard;
if (defined $CID) {
    $log->out(sprintf("Found Campaign Id: %s", $CID));
    if (!is_valid_id($CID)) {
        $log->out(sprintf("But it has wrong value! Script is stopped"));
        exit;
    }
    $only_shard = get_shard(cid => $CID);
}
foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    return if defined $only_shard && $only_shard != $shard ||
            defined $SHARD && $SHARD != $shard;
    my $camps_options = [];
    my $last_cid = 0;

    my $log_prefix_guard = $log->msg_prefix_guard("shard $shard:");
    my $max_cid = get_one_field_sql(PPC(shard => $shard), "SELECT MAX(cid) FROM camp_options");

    do {
        relaxed times => $SLEEP_TIME_COEF, sub {
            $log->out('Fetching camp_options minus_words chunk to fix');
            do_in_transaction {
                $camps_options = ($CID) ? get_all_sql(PPC(shard => $shard), 'SELECT cid, minus_words FROM camp_options WHERE cid=? AND minus_words != "" 
                                                                             AND minus_words IS NOT NULL FOR UPDATE', $CID)
                                           : get_all_sql(PPC(shard => $shard), 
                                                        'SELECT cid, minus_words FROM camp_options WHERE cid >? AND cid <= ?
                                                         AND minus_words != "" AND minus_words IS NOT NULL 
                                                         ORDER BY cid LIMIT ? FOR UPDATE', $last_cid, $max_cid, 1000);
                my $cids_cnt = scalar @$camps_options;
                $log->out("Got $cids_cnt campaigns to check and fix");
                if ($cids_cnt) {
                    $last_cid = $camps_options->[-1]->{cid};
                    my $minus_words_for_update = {};
                    foreach my $camp_options (@$camps_options) {
                        my $minus_words;

                        if ($REVERT) {
                            #Анти-функция: из json в строку старого формата, на случай, если надо откатить изменения.
                            $minus_words = MinusWordsTools::minus_words_array2interface_show_format(MinusWordsTools::minus_words_str2array($camp_options->{minus_words}));
                        } else {
                            $minus_words = MinusWordsTools::minus_words_array2str(MinusWordsTools::minus_words_str2array($camp_options->{minus_words}));
                        }

                        #Если уже ранее не было приведено к новому формату, то будем сохнарять в БД.
                        if ($minus_words ne $camp_options->{minus_words}) {
                            $minus_words_for_update->{$camp_options->{cid}}->{minus_words} = $minus_words;
                        }
                    }
                    if (keys %$minus_words_for_update) {
                        foreach my $minus_words_for_update_chunk (chunks([keys %$minus_words_for_update], 200)) {
                            do_mass_update_sql(PPC(shard=>$shard), 'camp_options', cid => {map {$_ => $minus_words_for_update->{$_}} @$minus_words_for_update_chunk});
                            $log->out(sprintf("Updated minus words for campaigns: %s", join ', ', @$minus_words_for_update_chunk));
                        }
                    }
                }
            };
        };
    } while @$camps_options > 0 && !$CID;
});

$log->out('FINISH');
