#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'на dev7 по 10-20 часов на 1 шард',
  comment => 'Минус слова на группу: заменяем старый формат минус слов (разделение по пробелам) на новый (json)
              Можно перезапускать с параметром sleep-coef

              Так как деплой сложный, имеет смысл запускать по шардам с перерывами для понимания полета, предлагается начинать с последних шардов. 
              Запустить на одном, посмотреть, что полет нормальный, внимательно смотреть на транспорты.
              запуск вида 20160830_groups_minus_words_from_str_to_json.pl --shard=7 --sleep-coef=1

              В случае осложнений запустить эту же миграцию с флагом --revert
              Это не вернет полностью в изначальное состояние, но поменяет формат данных в БД. Также следует сообщить релиз менеджеру, eboguslavskaya@ и hrustyashko@
              Пример запуска при осложнениях:
              20160830_groups_minus_words_from_str_to_json.pl --shard=7 --revert
              ',
}

=cut


use Direct::Modern;

use my_inc '..';

use ScriptHelper get_file_lock => undef;
use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;

use Yandex::DBTools;
use Yandex::DBShards qw/get_shard/;
use Yandex::Retry qw/relaxed/;
use Yandex::Validate qw/is_valid_id/;
use Yandex::ListUtils qw/xminus chunks/;
use Yandex::HashUtils qw/hash_merge hash_cut/;
use HashingTools qw/url_hash_utf8/;
use MinusWordsTools;
use utf8;

use List::MoreUtils qw/uniq all/;

my $SLEEP_TIME_COEF = 1;
my $CLIENTID;
my $SHARD;
my $REVERT = 0;

extract_script_params(
    'client_id=s' => \$CLIENTID,
    'shard=i' => \$SHARD,
    'sleep-coef' => \$SLEEP_TIME_COEF,
    'revert' =>  \$REVERT,
);
$log->out('START');

my $only_shard;
if (defined $CLIENTID) {
    $log->out(sprintf("Found Client Ids: %s", $CLIENTID));
    $CLIENTID = [split /\s*,\s*/, $CLIENTID];
    $only_shard = get_shard(ClientID => $CLIENTID->[0]);

    if (! all {is_valid_id($_) } @$CLIENTID  || !$only_shard) {
        $log->out(sprintf("But it has wrong value! Script is stopped"));
        exit;
    }

}
foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    return if defined $only_shard && $only_shard != $shard ||
            defined $SHARD && $SHARD != $shard;
    my $last_mw_id = 0;

    my $log_prefix_guard = $log->msg_prefix_guard("shard $shard:");

    if ($REVERT) {
        $log->out('ATTENTION! REVERT MODE!');
    }

    my $max_mw_id = get_one_field_sql(PPC(shard => $shard), ["SELECT MAX(mw_id) FROM minus_words",
                                      ($CLIENTID) ? (where => {ClientID => $CLIENTID}) : ()]);

    my ($deleted_mw_records_cnt, $updated_mw_records_cnt, $updated_group_records_cnt, $updated_mbanners_records_cnt) = (0,0,0,0);
    my $records_got = [];

    do {
        relaxed times => $SLEEP_TIME_COEF, sub {
            $log->out('Fetching minus_words records chunk to fix');

            if ($REVERT) {
                do_in_transaction {
                    $records_got = get_all_sql(PPC(shard => $shard), 
                                             'SELECT * FROM minus_words WHERE mw_id > ? AND mw_id <= ?
                                              ORDER BY mw_id LIMIT ?', $last_mw_id, $max_mw_id, 1000);
                    $last_mw_id = $records_got->[-1]->{mw_id} if (@$records_got);
                    if (@$records_got) {
                        my $mw_ids_for_update_revert = {};
                        foreach my $rec (@$records_got) {
                            my $text = MinusWordsTools::minus_words_array2interface_show_format(MinusWordsTools::minus_words_str2array($rec->{mw_text}));
                            $mw_ids_for_update_revert->{$rec->{mw_id}} = {mw_hash => url_hash_utf8($text), mw_text => $text};
                        }

                        $log->out(sprintf("REVERT: Updating records in minus_words with mw_ids(mw_id:hashcode:text): %s", 
                                  join ",", map {sprintf("%d:%s:%s", $_, $mw_ids_for_update_revert->{$_}->{mw_hash}, $mw_ids_for_update_revert->{$_}->{mw_text})} keys %$mw_ids_for_update_revert));

                        do_mass_update_sql(PPC(shard=>$shard), 'minus_words', mw_id => $mw_ids_for_update_revert);
                    }
                };
            } else {

            $records_got = ($CLIENTID) ? get_all_sql(PPC(shard => $shard), ['SELECT * FROM minus_words', 
                                                                            where => {mw_id__gt => $last_mw_id, 
                                                                                      mw_id__le => $max_mw_id,
                                                                                      ClientId => $CLIENTID},
                                                                            'ORDER BY mw_id LIMIT ?'], 3)
                                       : get_all_sql(PPC(shard => $shard), 
                                                        'SELECT * FROM minus_words WHERE mw_id > ? AND mw_id <= ?
                                                        ORDER BY mw_id LIMIT ?', $last_mw_id, $max_mw_id, 100);

            $last_mw_id = $records_got->[-1]->{mw_id} if (@$records_got);


            # если хеш уже прописан правильный, то эту фразу не просматриваем, она уже корректная.
            my $records = [grep {$_->{mw_hash} ne _get_hashcode($_->{mw_text})} @$records_got];
            $log->out(sprintf("Got %d records to check and fix and %d are old", scalar @$records_got, scalar @$records));

            if (@$records) {
                my $client_ids = [uniq(map {$_->{ClientID}} @$records)];

                # Выбираем все варианты минус-слов в старом и новом формате.
                my $all_uses = get_hashes_hash_sql(PPC(shard=>$shard), [
                               'SELECT mw_id, mw_hash, mw_text, ClientID FROM minus_words', 
                                where => {mw_hash  => [
                                            (uniq(map { _get_hashcode($_->{mw_text})} @$records),
                                            (map { $_->{mw_hash} } @$records))],
                                          ClientID => $client_ids},
                                        'ORDER BY mw_id'
                               ]);

                my %client_id_minus_words;
                foreach (values %$all_uses) {
                    push @{$client_id_minus_words{$_->{ClientID}}}, $_->{mw_id};
                }

                my $pid_mw_id_where = [map { (_AND => {'u.ClientID' => $_, mw_id => $client_id_minus_words{$_}}) } keys %client_id_minus_words];
                # По найденным ранее всем видам mw_id для одной фразы берем все их использования в группах    
                my $pid_mw_id = get_all_sql(PPC(shard => $shard), ['SELECT pid, mw_id, ClientID FROM phrases g 
                                                    JOIN campaigns c ON (c.cid = g.cid)
                                                    JOIN users u ON (u.uid = c.uid)',
                                                    where => {_OR => $pid_mw_id_where},
                                                    'ORDER BY mw_id DESC']);
                my $mbid_mw_id = get_all_sql(PPC(shard => $shard), ['SELECT mbid, mw_id, ClientID FROM mediaplan_banners mb 
                                                    JOIN campaigns c ON (c.cid = mb.cid)
                                                    JOIN users u ON (u.uid = c.uid)',
                                                    where => {_OR => $pid_mw_id_where},
                                                    'ORDER BY mw_id DESC']);

                my $records_hash = {map {$_->{mw_id} => $_} @$records};
                hash_merge $records_hash, $all_uses;
                # Чтобы потом не пересчитывать постоянно, сразу считаем "новый правильный" вид hashcode и текста минус-слов.
                foreach (values %$records_hash){
                    $_->{real_right_hashcode} = _get_hashcode($_->{mw_text});
                    $_->{real_right_text} = _get_json_text($_->{mw_text});
                }

                my $etalon_hashcodes = {};
                my $groups_for_update = {};
                my $mbanners_for_update = {};

                my @old_hashcodes;
                # Создаем эталонный хеш с хешкодами и соответствующими им правильными, актуальными mw_id,
                # чтобы в дальнейшем знать на что заменять надо устаревший вариант.
                foreach my $e (@$pid_mw_id, @$mbid_mw_id) {
                    my $hashcode = _get_hashcode($all_uses->{$e->{mw_id}}->{mw_text});
                    if ($hashcode eq $all_uses->{$e->{mw_id}}->{mw_hash}) {
                        # Если хешкод по тексту и хешкод в mw_hash совпадает, значит это уже текст в json, и можно считать его эталонным.
                        $etalon_hashcodes->{$hashcode."_".$e->{ClientID}} = $e->{mw_id} unless defined $etalon_hashcodes->{$hashcode."_".$e->{ClientID}};
                    } else {
                        # Если хешкод по тексту и хешкод в mw_hash НЕ совпадает, то откладываем, на случае если найдем более актуальный далее.
                        push @old_hashcodes, {hashcode_ClientID => $hashcode."_".$e->{ClientID}, mw_id => $e->{mw_id}};
                    }
                }

                foreach (@old_hashcodes) {
                    # Для тех минус-слов, которые в БД лежат только в старом варианте (в цикле выше не найдены их json эквиваленты) 
                    # делаем эти mw_id эталонными.
                    $etalon_hashcodes->{$_->{hashcode_ClientID}} = $_->{mw_id} unless defined $etalon_hashcodes->{$_->{hashcode_ClientID}};
                }

                foreach my $e (@$pid_mw_id, @$mbid_mw_id) {
                    my $hashcode = (exists $records_hash->{$e->{mw_id}})
                        ? $records_hash->{$e->{mw_id}}->{real_right_hashcode}
                        : _get_hashcode($all_uses->{$e->{mw_id}}->{mw_text});

                    if ($hashcode ne $all_uses->{$e->{mw_id}}->{mw_hash}
                        && $hashcode eq _get_hashcode($all_uses->{$e->{mw_id}}->{mw_text})
                        && $e->{mw_id} != $etalon_hashcodes->{$hashcode."_".$e->{ClientID}}) {
                        # Если хешкод совпадает с другой записью в minus_words, а mw_id не совпадает с эталонным - меняем.
                        # Меняем в группах старый mw_id, на новый эталонный.
                        my $new_value = {mw_id => $etalon_hashcodes->{$hashcode."_".$e->{ClientID}}, old_mw_id => $e->{mw_id}};
                        if ($e->{pid}) {
                            $groups_for_update->{$e->{pid}} = $new_value;
                        } elsif ($e->{mbid}) {
                            $mbanners_for_update->{$e->{mbid}} = $new_value;
                        }
                    }
                }

                my $mw_ids_for_delete = [];
                my $mw_ids_for_update = {};

                foreach (keys %$records_hash) {
                    my $val = $records_hash->{$_};
                    # Если в minus_words совпадения есть по hashcode, но различия по mw_id, то меняем в minus_words
                    # хешкод и текст на "новые правильные".
                    if ($val->{real_right_hashcode} ne $val->{mw_hash} &&
                        $etalon_hashcodes->{$val->{real_right_hashcode}."_".$val->{ClientID}}) {
                        $mw_ids_for_update->{$val->{mw_id}} = {
                            mw_hash => $val->{real_right_hashcode},
                            mw_text => $val->{real_right_text},
                        };
                    }
                }

                # Если запись в minus_words есть, а использование ее совсем нигде не найдено,
                # то удаляем mw_id из таблицы minus_words.
                push @$mw_ids_for_delete, @{xminus([keys %$records_hash], 
                                               [map {($_->{pid} && $groups_for_update->{$_->{pid}}) ? $groups_for_update->{$_->{pid}}->{mw_id} :
                                                     ($_->{mbid} && $mbanners_for_update->{$_->{mbid}}) ? $mbanners_for_update->{$_->{mbid}}->{mw_id}:
                                                     $_->{mw_id}} @$pid_mw_id, @$mbid_mw_id])};

                #  Удаляем собранные неиспользованные минус слова из таблицы minus_words
                if (@$mw_ids_for_delete) {
                    $log->out(sprintf("Deleting records from minus_words with mw_ids(mw_id:hashcode:text): %s",
                              join ";", map {sprintf("%d:%s:%s", $_, $records_hash->{$_}->{mw_hash}, $records_hash->{$_}->{mw_text})} @$mw_ids_for_delete));
                    do_delete_from_table(PPC(shard => $shard), 'minus_words', where => {mw_id=>$mw_ids_for_delete});
                    $deleted_mw_records_cnt += scalar(@$mw_ids_for_delete);
                }
                # Обновляем тексты и хешкоды в minus_words, на новый формат.
                if (%$mw_ids_for_update) {
                    foreach my $mw_ids_for_update_chunk (chunks([keys %$mw_ids_for_update], 200)) {
                        $log->out(sprintf("Updating records in minus_words with mw_ids(mw_id:hashcode:text): %s", 
                                  join ";", map {sprintf("%d:%s:%s", $_, $mw_ids_for_update->{$_}->{mw_hash}, $mw_ids_for_update->{$_}->{mw_text})} @$mw_ids_for_update_chunk));
                        do_mass_update_sql(PPC(shard=>$shard), 'minus_words', mw_id => hash_cut $mw_ids_for_update, @$mw_ids_for_update_chunk);
                        $updated_mw_records_cnt += scalar(@$mw_ids_for_update_chunk);
                    }
                }
                # Обновляем mw_id в группах, в случае, если успели задублироваться какие-то минус-слова.
                if (%$groups_for_update) {
                    foreach my $groups_for_update_chunk (chunks([keys %$groups_for_update], 200)) {
                        $log->out(sprintf("Updating records in phrases with pids(pid:old_mw_id:new_mw_id): %s", 
                                  join ";", map {sprintf("%d:%d:%d", $_, $groups_for_update->{$_}->{old_mw_id}, $groups_for_update->{$_}->{mw_id})} @$groups_for_update_chunk));

                        my $case_sql = join " ", map {
                               sprintf ("WHEN pid=%d AND mw_id=%d THEN %d", $_, $groups_for_update->{$_}->{old_mw_id}, $groups_for_update->{$_}->{mw_id} )
                            } @$groups_for_update_chunk;

                        do_sql(PPC(shard=>$shard), ["UPDATE phrases SET mw_id= CASE $case_sql ELSE mw_id END, LastChange=LastChange", where => {pid => [@$groups_for_update_chunk]}]);

                        $updated_group_records_cnt += scalar(@$groups_for_update_chunk);
                    }
                }
                if (%$mbanners_for_update) {
                    foreach my $mbanners_for_update_chunk (chunks([keys %$mbanners_for_update], 200)) {
                        $log->out(sprintf("Updating records in mediaplan_banners with mbids(mbid:old_mw_id:new_mw_id): %s", 
                                  join ";", map {sprintf("%d:%d:%d", $_, $mbanners_for_update->{$_}->{old_mw_id}, $mbanners_for_update->{$_}->{mw_id})} @$mbanners_for_update_chunk));

                        my $case_sql = join " ", map {
                               sprintf ("WHEN mbid=%d AND mw_id=%d THEN %d", $_, $mbanners_for_update->{$_}->{old_mw_id}, $mbanners_for_update->{$_}->{mw_id} )
                            } @$mbanners_for_update_chunk;

                        do_sql(PPC(shard=>$shard), ["UPDATE mediaplan_banners SET mw_id= CASE $case_sql ELSE mw_id END", where => {mbid => [@$mbanners_for_update_chunk]}]);

                        $updated_mbanners_records_cnt += scalar(@$mbanners_for_update_chunk);
                    }
                }
            }
            } # !REVERT
        };
    } while @$records_got > 0;
    $log->out(sprintf("\nDeleted minus_words records: %d\nUpdated minus_words records: %d\nUpdated phrases records: %d\nUpdated mediaplan_banners records: %d",
              $deleted_mw_records_cnt, $updated_mw_records_cnt, $updated_group_records_cnt, $updated_mbanners_records_cnt));
});

sub _get_hashcode {
    my $text = shift;
    return MinusWordsTools::minus_words_utf8_hashcode(
                               MinusWordsTools::minus_words_str2array($text)
           );
}

sub _get_json_text {
    my $text = shift;
    return MinusWordsTools::minus_words_array2str(
                               MinusWordsTools::minus_words_str2array($text)
           );    
}
$log->out('FINISH');
