#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "",
  comment => "Предварительно выполнить команду scp ppcdev1:/home/zhur/restore_dont_show_yacontext /tmp/restore_dont_show_yacontext"
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use BS::ResyncQueue qw/bs_resync/;
use Yandex::DBShards;
use Yandex::Retry;

use Settings;

my $BS_RESYNC_PRIORITY = BS::ResyncQueue::PRIORITY_ONE_SHOT_FIX_MODERATION_FLAGS;

$log->out('START');

open(my $fh, "<", "/tmp/restore_dont_show_yacontext") || die "Can't open file: $!";
my @cids = map {chomp; $_} <$fh>;
close($fh);


foreach_shard cid => \@cids, sub {
    my ($shard, $chunk) = @_;

    $log->out("chunk: ", $chunk);
    
    my $to_update = get_hash_sql(PPC(shard => $shard), ["SELECT cid FROM campaigns", WHERE => {dontShowYacontext => 'No', cid => $chunk}]); 
    if (!keys %$to_update) {
        $log->out("no changed data");
        return;
    }

    my $filtered_chunk = [grep {exists $to_update->{$_}} @$chunk];

    my @resync_data = map { { cid => $_, pid => 0, bid => 0, priority => $BS_RESYNC_PRIORITY } } @$filtered_chunk;
    $log->out( { resync_data => \@resync_data } );

    relaxed times => 2, sub {
        my $affected = do_sql(PPC(shard => $shard), ["UPDATE campaigns SET dontShowYacontext = 'Yes', ContextLimit = 254", WHERE => {cid => $filtered_chunk}]);
        $log->out("updated $affected campaigns");

        my $rows_affected_by_resync = bs_resync(\@resync_data);
        $log->out( { rows_affected_by_resync => $rows_affected_by_resync } );
    };
};

$log->out('FINISH');

