#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 минуты",
  comment => "Cтавим в очередь на конвертацию клиентов elama по списку логинов. Запускать после простановки тизера по отмашке gukserg@ или ppalex@!"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::ListUtils;
use Yandex::HashUtils;
use Yandex::TimeCommon qw/unix2human mysql2unix/;

use Path::Tiny;
use List::MoreUtils qw/part/;

use my_inc '..';

use Client;
use Client::ConvertToRealMoney;
use RBAC2::Extended;
use ScriptHelper;
use Settings;

use Primitives;
use PrimitivesIds qw/get_clientids get_login2clientid/;

my $OPERATOR_UID = 1;
my $agency_id = 322057; # elama
my $data_path = my_inc::path('./20160928_add_3000_elama_clients_to_curr_convert.data');
my $rbac = RBAC2::Extended->get_singleton($OPERATOR_UID) or $log->die("Can't connect to RBAC: $@");

$log->out('START');

my @logins = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");

$log->out('Got '. scalar @logins .' logins from file');

my $login2clientid = get_login2clientid(login => \@logins);
my $bad_logins = xminus(\@logins, [keys %$login2clientid]);
$log->out({not_found_logins => $bad_logins});

my $clientid2login = { reverse %$login2clientid };
my $clids = [ keys $clientid2login ];

my $clid2currencies = mass_get_client_currencies($clids);
my ($good_clids, $bad_clids) = part { $clid2currencies->{$_}->{work_currency} eq 'YND_FIXED' ? 0 : 1 } @$clids;
$log->out({bad_work_currency_logins => [ map {$clientid2login->{$_}} @$bad_clids ]} );

my $clients = get_all_sql(PPC(ClientID => $good_clids), ['
    SELECT ctfmt.ClientID
         , cfcc.country_region_id
         , cfcc.currency
    FROM clients_to_force_multicurrency_teaser ctfmt
    LEFT JOIN currency_convert_queue q ON ctfmt.ClientID = q.ClientID
    LEFT JOIN client_firm_country_currency cfcc ON ctfmt.ClientID = cfcc.ClientID
 ', WHERE => {
        'ctfmt.ClientID' => SHARD_IDS,
        'q.ClientID__is_null' => 1,
    }, '
    GROUP BY ctfmt.ClientID
    HAVING
            COUNT(DISTINCT cfcc.country_region_id) = 1
        AND COUNT(DISTINCT cfcc.currency) = 1
']);

my $not_selected_clids = xminus($good_clids, [ map { $_->{ClientID} } @$clients ]);
$log->out({not_selected_logins => [ map {$clientid2login->{$_}} @$not_selected_clids ]} );

$log->out('Selected '. scalar @$clients .' clients for add to currency convert');

if (@$clients) {
    my $convert_start_ts = mysql2unix('2016-09-30 00:00:00');
    my $convert_start_datetime = unix2human($convert_start_ts - 60);
    $log->out("convert_start_datetime $convert_start_datetime");

    my $client_ids = [ map { $_->{ClientID} } @$clients ];
    my $clid2nds = mass_get_client_NDS($client_ids, fetch_for_ynd_fixed_too => 1);
    my $clid2first_agency = Primitives::mass_get_client_first_agency($client_ids);
    my $clients_data = mass_get_clients_data($client_ids, [qw/allow_create_scamp_by_subclient/]);
    my $clid2chief_uid = {};
    for my $client_ids_chunk (chunks($client_ids, 5_000)) {
        # разбиваем на чанки, чтобы не падать по памяти при большом количестве клиентов
        hash_merge($clid2chief_uid, RBACElementary::rbac_get_chief_reps_of_clients($client_ids_chunk));
    }

    # по факту, уже продублировали почти все проверки из Client::can_convert_to_real_money в SQL запросе выше, поэтому её не используем
    my @convert_requests;
    my $clients_count = 0;
    for my $client (@$clients) {
        my $client_id = $client->{ClientID};
        my $login = $clientid2login->{$client_id};

        my $prefix_guard = $log->msg_prefix_guard("[login=$login,ClientID=$client_id]");

        my $client_nds = $clid2nds->{$client_id};
        unless (defined $client_nds) {
            $log->out("Skip - undefined NDS");
            next;
        }

        my $is_free_client = $clients_data->{$client_id}->{allow_create_scamp_by_subclient};
        if ($is_free_client) {
            $log->out("Skip - is free client");
            next;
        }

        my $currency = $client->{currency};
        my $country = $client->{country_region_id};

        $clients_count++;

        # единственность стран и валют и то, что они такие -- проверили в исходном SQL-запросе
        my @country_currencies = ({region_id => $country, currency => $currency});
        my $convert_type = Client::ConvertToRealMoney::get_convert_type($client_id, $currency, $client_nds, \@country_currencies);
        my $to_convert = {
            ClientID => $client_id,
            uid => undef, # SMS никому не пишем
            convert_type => $convert_type,
            new_currency => $currency,
            country_region_id => $country,
            email => undef, # отдельных писем не пишем, пишем только общее письмо по окончанию конвертации всех поставленных клиентов
            start_convert_ts => $convert_start_ts,
        };
        $log->out($to_convert);
        push @convert_requests, $to_convert;
    }

    $log->out("Got $clients_count to add in currency convert queue");
    if (@convert_requests) {
        $log->out("Add to currency_convert_queue...");
        Client::ConvertToRealMoney::mass_queue_currency_convert(\@convert_requests, ignore => 1, AgencyID => $agency_id);
    }

}

$log->out('FINISH');
