#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
[
    {
      type => 'script',
      when => 'after',
      time_estimate => "10 секунд на devtest",
      script => "/var/www/ppc.yandex.ru/protected/metricaFetchMobileInterests.pl"
    },
    {
      type => 'script',
      when => 'after',
      time_estimate => "1 секунда на devtest"
    }
]

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

my %data_to_change = (
    21672110 => {parent_goal_id => undef, name => "Бизнес", order_num => 100},
    21672115 => {parent_goal_id => undef, name => "Связь", order_num => 200},
    21672120 => {parent_goal_id => undef, name => "Образование", order_num => 300},
    21672125 => {parent_goal_id => undef, name => "Развлечения", order_num => 400},
    21672130 => {parent_goal_id => undef, name => "Финансы", order_num => 500},
    21672135 => {parent_goal_id => undef, name => "Здоровье и фитнес", order_num => 600},
    21672140 => {parent_goal_id => undef, name => "Спорт", order_num => 700},
    21672145 => {parent_goal_id => undef, name => "Образ жизни", order_num => 1000},
    21672150 => {parent_goal_id => undef, name => "Медицина", order_num => 1100},
    21672155 => {parent_goal_id => undef, name => "Новости", order_num => 1200},
    21672160 => {parent_goal_id => undef, name => "Персонализация", order_num => 1300},
    21672165 => {parent_goal_id => undef, name => "Инструменты для работы", order_num => 1400},
    21672175 => {parent_goal_id => undef, name => "Покупки", order_num => 1500},
    21672180 => {parent_goal_id => undef, name => "Утилиты", order_num => 1600},
    21672185 => {parent_goal_id => undef, name => "Транспорт", order_num => 1700},
    21672190 => {parent_goal_id => undef, name => "Путешествия", order_num => 1800},
    21672195 => {parent_goal_id => undef, name => "Погода", order_num => 1900},
    21672200 => {parent_goal_id => undef, name => "Музыка и аудио", order_num => 2000},
    21672485 => {parent_goal_id => undef, name => "Фото и видео", order_num => 2100},
    21672490 => {parent_goal_id => undef, name => "Книги", order_num => 2200},
    21672495 => {parent_goal_id => undef, name => "Подкасты", order_num => 2300},
    21672595 => {parent_goal_id => undef, name => "Социальные", order_num => 2400},
    21672105 => {parent_goal_id => undef, name => "Не определено", order_num => 2500},
    21672590 => {parent_goal_id => undef, name => "Игры", order_num => 2600},
    21672505 => {parent_goal_id => 21672590, name => "Экшен", order_num => 2610},
    21672510 => {parent_goal_id => 21672590, name => "Приключения", order_num => 2613},
    21672515 => {parent_goal_id => 21672590, name => "Аркады", order_num => 2616},
    21672520 => {parent_goal_id => 21672590, name => "Настольные", order_num => 2619},
    21672525 => {parent_goal_id => 21672590, name => "Карточные", order_num => 2622},
    21672530 => {parent_goal_id => 21672590, name => "Казино", order_num => 2625},
    21672535 => {parent_goal_id => 21672590, name => "Казуальные", order_num => 2628},
    21672540 => {parent_goal_id => 21672590, name => "Обучающие", order_num => 2631},
    21672545 => {parent_goal_id => 21672590, name => "Музыкальные", order_num => 2634},
    21672550 => {parent_goal_id => 21672590, name => "Головоломки", order_num => 2637},
    21672555 => {parent_goal_id => 21672590, name => "Гонки", order_num => 2640},
    21672560 => {parent_goal_id => 21672590, name => "РПГ", order_num => 2643},
    21672565 => {parent_goal_id => 21672590, name => "Симуляторы", order_num => 2646},
    21672570 => {parent_goal_id => 21672590, name => "Спортивные", order_num => 2649},
    21672575 => {parent_goal_id => 21672590, name => "Стратегии", order_num => 2652},
    21672580 => {parent_goal_id => 21672590, name => "Викторины", order_num => 2655},
    21672585 => {parent_goal_id => 21672590, name => "Словесные", order_num => 2658},
    21672500 => {parent_goal_id => 21672590, name => "Другие игры", order_num => 2699},
);

$log->out('START');

my $old_data = get_all_sql(PPCDICT,
    ["SELECT import_id, category_id, parent_category_id, name, state, order_num
       FROM targeting_categories",
    WHERE => {targeting_type => "rmp_interest", import_id => [keys %data_to_change]}]);
my $goal2category = {map {$_->{import_id} => $_->{category_id}} @$old_data};

$log->out('Preparing data to update');
my %update_data;
my @unprocessed_children;
for my $goal_id (keys %$goal2category) {
    my $new_data = delete $data_to_change{$goal_id};
    next if !defined $new_data;

    my $parent_category_id = undef;
    if (defined $new_data->{parent_goal_id}) {
        if (exists $goal2category->{$new_data->{parent_goal_id}}) {
            $parent_category_id = $goal2category->{$new_data->{parent_goal_id}};
        } else {
            push @unprocessed_children, $goal_id;
            next;
        }
    }
    $update_data{$goal_id} = {
        name => $new_data->{name},
        parent_category_id => $parent_category_id,
        state => 'Submitted',
        order_num => $new_data->{order_num},
        last_change => 'NOW()'
    };
}
my $cnt = scalar(keys %data_to_change);
$log->out("$cnt of initial entries were skipped");
if (@unprocessed_children) {
    my $msg = join(', ', @unprocessed_children);
    $log->out("Goal ids of children with unknown parents: $msg");
}
$log->out('Finished preparing data');
$log->out({message => "Currently in table", data => $old_data});
$log->out({message => "Table will be overwritten with following data", data => \%update_data});

$cnt = do_mass_update_sql(PPCDICT, 'targeting_categories', 'import_id',
    \%update_data, where => {targeting_type => "rmp_interest"},
    byfield_options => {last_change => {dont_quote_value => 1}}
);
$log->out("Updated $cnt of entries");

$log->out('FINISH');

