#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "3 минуты на devtest",
  comment => "Удаляем старые (неактуальные) цели букинга. Можно перезапускать."
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry;

use my_inc '..';

use ScriptHelper;
use Settings;
use PrimitivesIds;

my $AGENCY_LOGIN = 'booking-mcc';
my @GOOD_GOALS = (23128920, 23245885);

$log->out("START");

my $AGENCY_ID = get_clientid(login => $AGENCY_LOGIN);
my $AGENCY_UIDS = get_one_column_sql(PPC(ClientID => $AGENCY_ID), ["select uid from users", where => { ClientID => SHARD_IDS } ]);

$log->out("Selecting campaigns of agency $AGENCY_LOGIN");
my $cids = get_one_column_sql(PPC(shard => 'all'), ['select cid from campaigns', where => { AgencyUID => $AGENCY_UIDS }]);
$log->out("Selected " . scalar(@$cids) . " campaigns: ", $cids);

my $total_deleted_qty = 0;
foreach_shard cid => $cids, chunk_size => 100, sub {
    my ($shard, $cids_chunk) = @_;
    $log->out("Processing campaigns chunk:", $cids_chunk);
    my $goals_to_delete = get_all_sql(PPC(shard => $shard), ["select * from camp_metrika_goals",
                                                               where => { cid => $cids_chunk,
                                                                          goal_id__not_in => \@GOOD_GOALS,
                                                                          goals_count => 0,
                                                                          context_goals_count => 0 }]);
    my %goals_to_delete_by_cid = ();
    for my $row (@$goals_to_delete) {
        push @{$goals_to_delete_by_cid{$row->{cid}}}, $row;
    }
    for my $cid (@$cids_chunk) {
        my $guard = $log->msg_prefix_guard("[cid=$cid]");
        if (my $to_delete = $goals_to_delete_by_cid{$cid}) {
            relaxed sub {
                $log->out("Goals to delete:", @$to_delete);
                my $deleted_qty = do_delete_from_table(PPC(cid => $cid), 'camp_metrika_goals',
                                                                         where => { cid => $cid,
                                                                                    goal_id => [map { $_->{goal_id} } @$to_delete],
                                                                                    goals_count => 0,
                                                                                    context_goals_count => 0 });
                $log->out("Deleted rows qty: " . ($deleted_qty+0));
                $total_deleted_qty += $deleted_qty;
            };
        }
    }
};
$log->out("Total deleted rows qty: " . $total_deleted_qty);

$log->out("FINISH");
