#!/usr/bin/perl

=head1 DEPLOY

# approved by liosha
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 минута",
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use ShardingTools qw/ppc_shards/;
use BS::ResyncQueue qw/bs_resync/;
use Yandex::DBTools;
use Yandex::Retry;

use Settings;

my $BS_RESYNC_PRIORITY = BS::ResyncQueue::PRIORITY_DEFAULT;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("checking shard $shard");
    # динамических кампаний пока немного, не лимитируем
    my $chunk = get_one_column_sql(PPC(shard => $shard), [
            'SELECT cid FROM campaigns',
            WHERE => {
                type => "dynamic",
                _OR => {
                    ContextLimit__ne => 254,
                    dontShowYacontext__ne => 'Yes',
                },
            },
        ]);

    $log->out("shard $shard, campaigns: ", $chunk);
    next if !@$chunk;

    relaxed times => 2, sub {
        my $affected = do_update_table(PPC(shard => $shard), campaigns => {
                ContextLimit => 254,
                dontShowYacontext => 'Yes',
            },
            where => {cid => $chunk},
        );
        $log->out("updated $affected campaigns");

        my @resync_data = map { { cid => $_, pid => 0, bid => 0, priority => $BS_RESYNC_PRIORITY } } @$chunk;
        my $rows_affected_by_resync = bs_resync(\@resync_data);
    };
};

$log->out('FINISH');

