#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => 'час на девтест',
  comment => 'снимаем тизер у беларусских [суб]клиентов',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw(chunks xminus);
use Yandex::DBShards;

use my_inc '..';

use List::MoreUtils qw(part uniq);

use ScriptHelper;
use Settings;
use ShardingTools qw(ppc_shards);
use geo_regions ();

$log->out('START');

for my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard_$shard]");
    $log->out('Fetching clients to possible remove teaser');
    my $clients = get_all_sql(PPC(shard => $shard), ['
        SELECT STRAIGHT_JOIN
               ctfmt.ClientID
             , (cl.country_region_id = ?) AS belarus_country
             , (
                     COUNT(DISTINCT cfcc.country_region_id) = 1
                 AND MAX(cfcc.country_region_id) = ?
               ) AS only_belarus
             , (MAX(ag_cl.country_region_id) = ?) AS agency_belarus_country
             , MAX(acr.agency_client_id) AS primary_AgencyID
        FROM clients_to_force_multicurrency_teaser ctfmt
        LEFT JOIN clients cl ON cl.ClientID = ctfmt.ClientID
        LEFT JOIN currency_convert_queue ccq ON ccq.ClientID = ctfmt.ClientID
        LEFT JOIN client_firm_country_currency cfcc ON cfcc.ClientID = ctfmt.ClientID
        LEFT JOIN agency_client_relations acr ON acr.client_client_id = ctfmt.ClientID
                                                 AND acr.bind = "Yes"
        -- вдруг агентство лежит в том же шарде
        LEFT JOIN clients ag_cl ON acr.agency_client_id = ag_cl.ClientID
        WHERE
                IFNULL(cl.work_currency, "YND_FIXED") = "YND_FIXED"
            AND ccq.ClientID IS NULL
        GROUP BY ctfmt.ClientID
        HAVING belarus_country
            OR only_belarus
            OR agency_belarus_country
            OR (primary_AgencyID > 0 AND MAX(ag_cl.ClientID) IS NULL) -- агентства нет в этом шарде
        ORDER BY ctfmt.ClientID
    '], $geo_regions::BY, $geo_regions::BY, $geo_regions::BY);
    $log->out('Got ' . scalar(@$clients) . ' clients to possible remove teaser');

    $log->out('Partitioning clients for teaser removal and for further checks');
    my ($should_remove_teaser, $possible_by_agency) = part {
        ($_->{belarus_country} || $_->{only_belarus} || $_->{agency_belarus_country}) ? 0 : 1
    } @$clients;
    $should_remove_teaser //= [];
    $possible_by_agency //= [];
    $log->out('Got ' . scalar(@$should_remove_teaser) . ' clients for teaser removal and ' . scalar(@$possible_by_agency) . ' for agency check');
    undef $clients;

    if (@$should_remove_teaser) {
        $log->out('Removing teasers');
        _remove_teaser($shard, $should_remove_teaser);
    }
    undef $should_remove_teaser;

    if (@$possible_by_agency) {
        my @agency_ids = uniq map { $_->{primary_AgencyID} } @$possible_by_agency;
        $log->out('Got ' . scalar(@agency_ids) . ' agencies to check for Belarus');
        my %belarus_agid;
        foreach_shard ClientID => \@agency_ids, chunk_size => 1_000, sub {
            my ($shard, $agency_ids) = @_;
            $log->out("Checking agencies chunk in shard $shard");
            my $belorus_agency_ids = get_one_column_sql(PPC(shard => $shard), ['
                SELECT ClientID
                FROM clients
             ', WHERE => {
                    ClientID => $agency_ids,
                    country_region_id => $geo_regions::BY,
             },
            ]);
            for my $agency_id (@$belorus_agency_ids) {
                $belarus_agid{$agency_id} = undef;
            }
        };

        $log->out('Checking clients for belorussian agencies');
        my @clients_to_remove_teaser = grep { exists $belarus_agid{ $_->{primary_AgencyID} } } @$possible_by_agency;
        if (@clients_to_remove_teaser) {
            $log->out('Removing teasers for ' . scalar(@clients_to_remove_teaser) . ' belorussian agency clients');
            _remove_teaser($shard, \@clients_to_remove_teaser);
        }
    }
    undef $possible_by_agency;
}

$log->out('FINISH');


sub _remove_teaser {
    my ($shard, $clients) = @_;

    for my $clients_chunk (chunks $clients, 1_000) {
        $log->out('Removing teaser for clients chunk:');
        for my $client (@$clients_chunk) {
            $log->out($client);
        }
        my @clientids_to_remove_teaser = map { $_->{ClientID} } @$clients_chunk;
        my $cur_teasers = get_all_sql(PPC(shard => $shard), ['SELECT * FROM clients_to_force_multicurrency_teaser', WHERE => {ClientID => \@clientids_to_remove_teaser}]);
        $log->out("current teaser data before remove:", $cur_teasers);
        do_delete_from_table(PPC(shard => $shard), 'clients_to_force_multicurrency_teaser', where => {ClientID => \@clientids_to_remove_teaser});
    }
}
