#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 минут",
  comment => "
Перезабираем из BannetStorage креативы с битой кодировкой в названии
Можно перезапускать и запускать на ТС
  "
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use Direct::Creatives;
use ShardingTools qw/ppc_shards/;
use Yandex::ListUtils qw/chunks/;

$log->out('START');

for my $shard (ppc_shards()) {
    my $rows = get_all_sql(PPC(shard => $shard), "select creative_id, name, ClientID as client_id from perf_creatives");
    my @to_sync;
    for my $creative (@$rows) {
        if ($creative->{name} =~ /Ð|Ñ/) {
            push @to_sync, $creative;
        }
    }
    for my $chunk (chunks \@to_sync, 100) {
        $log->out({ sync_creatives => $chunk });
        Direct::Creatives::sync_creatives($chunk);
    }
}

$log->out('FINISH');

