#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
[
    {
      type => 'script',
      when => 'after',
      time_estimate => "5 минут на devtest"
    },
    {
      type => 'sql',
      webstop => "0",
      db => "ppc:1",
      when => 'after',
      time_estimate => "1 секунда",
      comment => "Выполнять после скрипта, так как до его запуска поправленные задачи опять сломаются",
      sql => [
        "DELETE FROM camp_copy_reports_queue WHERE id = 1266 AND statusReport = 'Error'",
        "UPDATE camp_copy_reports_queue SET statusReport = 'New', tries_count = 0 WHERE id = 1292 AND statusReport = 'Error'",
      ]
    }
]

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;
use Yandex::ListUtils qw/xsort/;

use Direct::RetargetingConditions;
use Direct::Model::RetargetingCondition;

$log->out('START');

my $cnt = 0;
my $client_cnt = 0;
for my $shard (ppc_shards()) {
    my $prefix = $log->msg_prefix_guard("[Shard_$shard]");
    my $ClientIDs = get_one_column_sql(PPC(shard => $shard),
        "SELECT ClientID
           FROM retargeting_conditions
         WHERE is_deleted = 0
         GROUP BY ClientID
         HAVING COUNT(condition_name) > COUNT(DISTINCT condition_name)");
    my $selected_cnt = scalar @$ClientIDs;
    $log->out("Selected $selected_cnt ClientIDs to change");

    for my $ClientID (@$ClientIDs) {
        $log->out("Processing client with id $ClientID");
        $client_cnt++;
        my $ret_conds = Direct::RetargetingConditions->get_by(client_id => $ClientID)->items;
        $ret_conds = [xsort {$_->condition_name} @$ret_conds];

        my %used_names;
        my @conds_to_rename;
        for my $ret_cond (@$ret_conds) {

            my $will_rename = 0;
            my $version = 2;
            my $orig_name = $ret_cond->condition_name;

            $orig_name =~ s/^\s+|\s+$//g;
            $orig_name =~ s/ё/е/g;
            $orig_name =~ s/Ё/Е/g;

            if ($orig_name ne $ret_cond->condition_name) {
                $ret_cond->condition_name($orig_name);
            }
            while (exists $used_names{lc $ret_cond->condition_name}) {
                $ret_cond->condition_name("$orig_name v.$version");
                $version ++;
                $will_rename = 1;
            }
            $used_names{lc $ret_cond->condition_name} = undef;

            if ($will_rename) {
                push @conds_to_rename, $ret_cond;
                $cnt++;
                $log->out({msg => "Will rename condition", ret_cond_id => $ret_cond->id, new_name => $ret_cond->condition_name, old_name => $orig_name});
            }
        }

        if (@conds_to_rename) {
            my $manager = Direct::Model::RetargetingCondition::Manager->new(items => \@conds_to_rename);
            $manager->update();
        }
    }
}
$log->out("Totally changed $cnt retargetings for $client_cnt clients");

$log->out('FINISH');

