#!/usr/bin/perl

=head1 DEPLOY

# approved by hmepas
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2-3 минуты devtest",
  comment => "
    Рассервисирует не mcb кампании которые были автосервисированны на mcb менеджера
  "
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;
use PrimitivesIds qw/get_uid2clientid/;
use RBAC2::Extended;
use BS::ResyncQueue;

my @MANAGER_LOGINS =  qw/yndx-malysheva yndx-kurchanova yndx-sapozhnikova-teamleader
                yndx-maiia-teamleader yndx-liyakh yndx-mech yndx-zlatales-teamleader
                yndx-novarchuk olga-bulahova yndx-ksandeer/;

my $DRY_RUN = 0;

extract_script_params(
    'dry-run' => \$DRY_RUN,
);

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton(1);

my $manager_login_by_uid = get_hash_sql(PPC(shard => 'all'), 
   ['SELECT uid, login FROM users', where => {login => \@MANAGER_LOGINS }]
);

for my $shard (ppc_shards()) {


    my $rows = get_all_sql(PPC(shard => $shard), [
       'SELECT cid, ManagerUID, uid FROM campaigns',
        where => {
          LastChange__gt => '2016-10-09 00:00:00',
          ManagerUID => [keys %$manager_login_by_uid],
          type__ne => 'mcb',
        }]);

    my (%cids_by_manager_uid, @uids);
    for my $row (@$rows) {
        push @{ $cids_by_manager_uid{$row->{ManagerUID}}{$row->{uid}} }, $row->{cid};
        push @uids, $row->{uid};
    }
    my $client_id_by_uid = get_uid2clientid(uid => \@uids);

    for my $manager_uid (keys %cids_by_manager_uid) {
        for my $uid (keys %{ $cids_by_manager_uid{$manager_uid} }) {
            my $manager_login = $manager_login_by_uid->{$manager_uid};
            $log->out( "try to delete for manager - $manager_login(uid $manager_uid)");
            my $cids = $cids_by_manager_uid{$manager_uid}{$uid};
            my $client_id = $client_id_by_uid->{$uid};
            $log->out( "uid - $uid, campaigns " . join ',' => @$cids );
            my $errorcode;
            $errorcode = move_scamps_to_nscamps($rbac, $cids, $manager_uid, $uid, $client_id) unless $DRY_RUN;
            if ( $errorcode ) {
                $log->out( "rbac ERROR: code " . $errorcode );
            } else {
                $log->out( "rbac OK " );
            }
        }
    }
}

$log->out('FINISH');


sub move_scamps_to_nscamps
{
    my ($rbac, $cids, $manager_uid, $client_uid, $client_id) = @_;

    my $errorcode = $rbac->Handle('RBAC_DropSCampaign', {
        client_uid  => $client_uid
        , client_id => $client_id
        , manager_uid => $manager_uid
        , objects => $cids
    });
    return $errorcode if $errorcode;

    $errorcode = $rbac->Handle('RBAC_CreateNSCampaign', {
          client_uid  => $client_uid
        , client_id => $client_id
        , objects => $cids
    });
    return $errorcode if $errorcode;

    my $commit_result = $rbac->Commit();
    return $commit_result if $commit_result;

    do_update_table(PPC(cid => $cids), 'campaigns', {ManagerUID => undef}, where => {cid => $cids});
    bs_resync_camps($cids);

    return;
}


