#!/usr/bin/perl


=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "предположительно несколько минут",
  comment => "./20161103_stop_creative_banners.pl"
}

=cut

use my_inc '..';

use Direct::Modern;
use Settings;
use Yandex::DBTools;
use ScriptHelper;
use Yandex::ListUtils qw/chunks/;
use Direct::Validation::Banners qw/validate_suspend_banners/;
use List::MoreUtils qw/uniq/;
use Yandex::DBShards;
use Direct::Banners;
use Direct::Campaigns;
use JSON;
use RBAC2::Extended;
use MailNotification;
use ShardingTools;

$log->out('START');

my $rbac = RBAC2::Extended->get_singleton(1);
MailNotification::save_UID_rbac(1, $rbac);

my $processed_bids = 0;
foreach_shard shard => [ppc_shards()], sub {
    my ($shard, $ids) = @_;

    my $creative_ids = get_one_column_sql(PPC(shard => $shard), "SELECT creative_id FROM perf_creatives WHERE template_id IN (706,707,708,713)");
    my $ids_in = join ",", @$creative_ids;

    my $bids = get_one_column_sql(PPC(shard => $shard),
                                  "SELECT ban.bid
                                  FROM 
                                    banners ban 
                                    JOIN (
                                        SELECT 
                                          b.pid,
                                          COUNT(DISTINCT b.bid) AS total,
                                          COUNT(DISTINCT IF(b.statusShow = 'No' AND bp.creative_id NOT IN ($ids_in), b.bid, NULL)) AS stoped,
                                          COUNT(DISTINCT IF(b.statusShow = 'Yes' AND bp.creative_id IN ($ids_in), b.bid, NULL)) AS active
                                        FROM (select distinct pid from banners_performance where creative_id IN ($ids_in)) AS gr
                                          JOIN banners b ON b.pid = gr.pid
                                          JOIN banners_performance bp USING(bid) 
                                          JOIN phrases p ON p.pid = b.pid
                                        WHERE p.lastChange <= '2016-08-25'
                                        GROUP BY b.pid
                                        HAVING total = stoped + active AND stoped > 0 AND total < 22) AS t ON ban.pid = t.pid
                                  WHERE
                                    ban.statusShow = 'Yes'");

    $log->msg_prefix("[shard $shard]");
    $log->out(sprintf "found %d banners", scalar @$bids);

    my $banners = Direct::Banners->get_by(banner_id => $bids)->items;
    my @cids = uniq map { $_->campaign_id } @$banners;
    my $campaigns = Direct::Campaigns->get_by(campaign_id => \@cids)->items_by('id');

    for my $chunk (chunks $banners, 500) {
        my @to_suspend;
        for my $banner (@$chunk) {

            $processed_bids++;
            $log->die("already processed $processed_bids") if $processed_bids > 1300;

            $log->out("process bid " . $banner->id);
            $banner->campaign($campaigns->{$banner->campaign_id});
            my $vr = validate_suspend_banners([$banner]);
            unless ($vr->is_valid) {
                $log->out(sprintf "bid %d suspend errors: %s", $banner->id, join ";", @{$vr->get_error_texts});
                next;
            }
            $banner->status_show('No');

            $log->out("suspend banner " . $banner->id);
            $log->out("banner state: " . to_json($banner->to_hash));
            push @to_suspend, $banner;
        }

        if (@to_suspend) {
            my $banners = Direct::Banners->new(items => \@to_suspend);
            # 1 - is UID
            $banners->suspend(1);
        }
    }
};

$log->out('FINISH');
