#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 секунд",
  comment => "Сбрасываем НДС старым белорусским клиентам"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;

$log->out('START');

foreach my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    my $bad_nds_data = get_all_sql(PPC(shard => $shard),
       "SELECT nds.clientid, nds.date_from, nds.date_to, nds.nds FROM client_nds nds
        LEFT JOIN clients c USING(ClientID)
        WHERE c.country_region_id = 149
        AND IFNULL(c.work_currency, 'YND_FIXED') = 'YND_FIXED'
        AND nds.date_from = '2012-01-30'");
    if (@$bad_nds_data) {
        $log->out('Got '. scalar @$bad_nds_data .' clients for delete NDS:');
        $log->out({bad_nds_data => $bad_nds_data});
        my $bad_nds_clientids = [ map { $_->{clientid} } @$bad_nds_data ];
        foreach my $clientid_chunk (chunks($bad_nds_clientids, 1000)) {
            do_in_transaction {
                do_delete_from_table(PPC(shard => $shard), 'client_nds', where => {ClientID => $clientid_chunk});
                do_mass_insert_sql(PPC(shard => $shard), "INSERT IGNORE INTO clients_to_fetch_nds (ClientID) VALUES %s", [ map { [$_] } @$clientid_chunk ]);
            };
        }
    } else {
        $log->out("No clients for delete NDS");
    }
    $log->out("Done");
}

$log->out('FINISH');

