#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 seconds",
  comment => "запуск без параметров ./deploy/20161111_creatives_update_preview_url.pl"
}

=cut

use Direct::Modern;
use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;

$log->out('START');
while (defined ($_ = <DATA>)) {
    my ($creative_id, $current_url, $new_url) = split /,\s+/, $_;
    $new_url =~ s/(^\s+|\s+$)//g;
    $current_url =~ s/(^\s+|\s+$)//g;
    my $affected = do_update_table(PPC(creative_id => $creative_id), perf_creatives => {
        preview_url => $new_url
    }, where => {creative_id => $creative_id, creative_type => 'canvas', preview_url => $current_url});
    if ($affected + 0) {
        $log->out(sprintf "creative_id %d set url %s", $creative_id, $new_url);
    } else {
        $log->out(sprintf "skip creative_id %d", $creative_id);
    }
}
$log->out('FINISH');



__DATA__
1073742382, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9jtfbm000c28d97ab1jdtg/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/84759b36-7c42-4076-b4d1-0c0248b5909e/orig
1073742384, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9molhp000c28d97a3t8gu0/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/a5f67776-0130-4cbd-8b83-2520fb408012/orig
1073742385, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9mp596000cf86b222ff9fo/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/aa83d5cc-6082-4263-a7af-c93194274102/orig
1073742387, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9n2osf000c28d97abdy85c/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/04735cf3-3e70-449b-a9b1-29db57a3c616/orig
1073742388, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9n2onc000cf86b22ddcxv3/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/1d27b3e9-e4c4-4c13-996d-d500ce87029c/orig
1073742389, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9nqs9x000c28d97afpso9y/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/69793/ddb0de93-6f0b-4610-bc46-503c45e9c725/orig
1073742390, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9nqrnn000cf86b227gny9h/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/4ef7c985-5003-4f4b-b605-718c7156d6e1/orig
1073742395, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rc4um000cf86b222w1ge6/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/4bd7e8f2-bddb-4243-8db2-e911b7b1d070/orig
1073742394, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rc4bu000c28d97a3833ll/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/46048c21-5c1a-40a0-b9d3-6cb2ffaec8ae/orig
1073742392, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rc46h000cf86b2251vji5/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/0c4bd624-bfe9-4730-94b6-a0e34a20e414/orig
1073742393, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rc4cg000cdfc2104ls8sv/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/ed8b78d1-5476-465b-ad3b-aa3f3e064b2c/orig
1073742397, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rd2jn000cdfc2109ye95y/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/093b793e-449c-4fce-af4a-58102f3f09ff/orig
1073742398, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rd1qx000cf86b22ddrv44/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/a8cd824b-840e-498b-b679-a52f8252de25/orig
1073742396, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rd1yg000cdfc210dvnjpu/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/a91cb19e-d26d-4fd6-a067-014ca4c3068d/orig
1073742399, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rd1v2000c28d97aau9owl/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/fd9b02f2-ca0d-4906-bfbe-4c4b88d67aa3/orig
1073742400, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9repy0000cf86b22dmtmuc/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/ec684c55-421b-400f-95b0-34eb0aed6fb2/orig
1073742401, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rerae000c28d97a4cp5q7/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/f74a273b-7957-4889-9662-5d274832fd45/orig
1073742402, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9repn1000cdfc21033wba1/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/8f058ea4-235f-45b0-97cc-71d2b2eca510/orig
1073742403, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9req3d000cdfc210cu1jv6/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/1da678a6-1a71-4866-a491-c9086093a880/orig
1073742405, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rftuz000c28d97a4662un/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/654b1104-9aad-4049-9f45-e3458200c5ab/orig
1073742404, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rfttp000cdfc2104fiysd/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/4a2cf335-e0b3-4e55-bebf-094eccdee0d2/orig
1073742407, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rg3yb000c28d97a5hvagx/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/b31437d2-113a-4b2c-9b61-a5d1b2374f82/orig
1073742406, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9rftqk000cf86b226jvpza/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/817b1a97-84a2-45c1-bf62-1a078e1e95d5/orig
1073742410, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9ritrw000c28d97a1t4n5x/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/c071aff2-f693-455a-8c93-0699d932a132/orig
1073742408, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rity4000c28d97a5i74yi/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/04f4ac40-408e-40dc-ada2-8e91c07f021a/orig
1073742411, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/iv9rit7n000cdfc2107b4uv6/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/a0bb913b-d60a-4764-925d-94ae74ec553d/orig
1073742409, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/iv9riv4n000cf86b222s4ghv/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/2bc51b19-0940-4e5f-a747-3dc1a32aebe4/orig
1073742413, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaqdbkn000cf86b221pqgdv/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/97845f4e-9c35-46cc-83df-cf4d4381ee32/orig
1073742412, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivaqdbzp000cdfc2106omyj9/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51858/5b31f3fb-f92e-4ce1-963c-21a1bdd70f21/orig
1073742414, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaqikb3000c28d97a6mhp45/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/47386/90c53c0c-9576-4157-bcb7-1ef0aee17ad8/orig
1073742415, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivaqy5um000c28d97a2mvv4d/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/92fc1f83-3a42-49ab-8a5e-a8469678ad0c/orig
1073742417, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaqy5xx000cf86b229mhj3y/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/fea3e77c-8907-4deb-bdbf-4759a32921f2/orig
1073742418, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaqy5ug000cf86b227jua34/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/a75235b6-fea7-48eb-ba03-8407f4865a41/orig
1073742416, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaqy5s7000cdfc21027kasg/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/25f26e98-6b37-44b2-8be2-ad3b514d79ee/orig
1073742421, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivas8xk9000cf86b2295oo2r/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/9f819585-7a5d-4857-bb80-220579a91408/orig
1073742422, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivas8y4x000c28d97agfruzx/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/6b8881b4-db30-4e90-9e97-5b2fc3548deb/orig
1073742420, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivas8wr6000cdfc2104dg1o6/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/307a6b04-65b7-447c-9c1a-6c4312a9f86e/orig
1073742419, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivas8wpv000cf86b227ls8w0/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/8fff7fe7-15c6-46a4-96b1-a9294329c722/orig
1073742426, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivau1v36000cdfc210cb8lhl/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/bb00d6cd-5f3f-472f-960c-a02cbbf70c22/orig
1073742424, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivau1yeu000c28d97age3d5s/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/325febac-cac5-46a6-a0db-07e95b77ab6d/orig
1073742425, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivau1wtm000cf86b223vwtdo/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/72f5b4bd-6701-47c4-a338-98307327d603/orig
1073742423, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivau1vzp000c28d97ae4u6xx/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/3cf2ab30-91d8-46da-a282-11a9355f1f12/orig
1073742429, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaul7ou000c28d97a7xdwul/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/166055f6-042a-47eb-b404-9c8875036837/orig
1073742430, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaul7dz000c28d97a1guh7b/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/e7d430b3-cd34-45b6-8f37-8880ab0d44e8/orig
1073742427, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivaul8qr000cf86b222g3eqg/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/52be9672-312c-4b5b-8459-b8cf50084a11/orig
1073742428, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaul7xs000cdfc210e9e1hj/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/41244/a0a2ac05-e1ef-41a9-b955-735ab472fee7/orig
1073742432, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaupofe000c28d97ad5efm3/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/1b0dc037-0815-44d2-aa69-de41b6d13582/orig
1073742433, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivaupl8m000cf86b22fzjjpg/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/e8d3d259-5b78-4bf2-8bea-814c75deab28/orig
1073742431, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivauppvr000cf86b22g9hohu/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/28578/2f7741c0-68eb-4835-a0f3-6ae91951f8d9/orig
1073742434, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivaupmht000cdfc2105tk4jf/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/26d4216e-9360-4ff3-b55b-6f9ae2110e3a/orig
1073742437, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivav78ib000cdfc2100jvxnt/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/905ee54c-ca5b-4556-8bc1-9051e13d405c/orig
1073742438, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivav78fb000c28d97aeaefp4/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/c364192c-12b1-48c9-8c2f-6024db019f2b/orig
1073742435, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivav791w000cf86b22g7oxr0/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/f2bae140-f2c5-47b8-a101-c0523595fe0d/orig
1073742436, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivav7804000cf86b22a9sgad/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/6169a3cd-c7ba-466d-bafd-b4180e19b218/orig
1073742440, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivavf8sn000c28d97a9spull/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/9ffd2d43-b293-4ee8-925b-5dafe42a3755/orig
1073742441, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivavf96l000cf86b226kry61/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/49fc77b2-4eb6-4a25-b7bf-0db1e0f577b8/orig
1073742439, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivavf9nm000cdfc210cpnntt/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/3e59b6f7-ec86-4be2-9773-3ba6606c4f79/orig
1073742442, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivavf8pz000cf86b22d82sjq/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/de903b63-f25d-40d2-aed9-bfa829084455/orig
1073742444, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivavqxrg000cdfc2103r6ncx/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/7fb9a926-4843-4584-8851-ca1f2b4f55ba/orig
1073742445, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivavqxfw000cf86b220v4tua/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/fd9c927b-0d63-40c8-bba0-85d0157e7d18/orig
1073742446, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivavqxjz000c28d97aetwbii/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/e7bea227-c940-42fd-8e1c-8de14504ea4d/orig
1073742443, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivavqxkc000c28d97af1o4dr/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/aa58de33-2676-4f89-88de-8778d4dcde83/orig
1073742448, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb0awqk000cdfc2107zk2tv/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/526032d3-6a98-43c6-be5e-3dccca74d01f/orig
1073742449, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb0i1uo000cf86b22fma4rd/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/b547a774-13c7-46de-87ad-6d41ad5442da/orig
1073742450, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb10bxb000cf86b22dcmmjt/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/ee239b14-1c28-4604-8b16-6d60e2b9531b/orig
1073742452, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb10c5e000cf86b221n0ro7/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/4a7ff722-0620-4c6c-92d4-823adf879ef0/orig
1073742451, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb10cr3000c28d97a9jcxtn/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/0e7286b0-ae4a-49d8-a963-52ae945d15dd/orig
1073742453, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb10c50000cdfc210dy1f3i/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/43884584-1a36-4993-b0b9-2c8ccba3c149/orig
1073742454, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb1g897000cf86b22928lfz/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/49530/5ba4d5bc-4f6b-45b8-bc85-32bcc6b4a301/orig
1073742455, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb1gb55000cdfc2100s65qs/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/7c92c0d1-9569-45d9-adfd-c8b50007a750/orig
1073742457, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb1g8p8000c28d97adl2u0j/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/b7b5315c-4f5e-4de4-a867-94a37427fabb/orig
1073742456, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb1g865000cdfc21038flp4/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/c8134382-e072-4407-8bf1-2e64ab9bcb94/orig
1073742459, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb1uvmi000cf86b220b020t/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/ee51e7e7-04f3-4552-b198-5dbe95bbd18f/orig
1073742460, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb1uv1b000cdfc210089q0u/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/9cc948d3-e3ae-4828-9a57-30bf7ca1bc52/orig
1073742458, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb1uv1e000cdfc2100a1l7p/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/04117883-83ef-4c28-94e6-bd572c29ebf7/orig
1073742461, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb1uuwk000c28d97acwymln/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/51220/2b17c82b-9d86-4217-9908-6f66a2f62f62/orig
1073742462, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb40s1q000c28d97a4392ru/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/69793/9f5207a7-d301-469d-8a83-01c0e7e7d626/orig
1073742463, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb40s6w000cdfc21086qkhg/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/69793/eacb5d85-28b7-4775-b699-ee2abb04143f/orig
1073742465, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3347/ivb40s22000cf86b229b8q1b/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/69793/4887a44d-c078-476b-a431-4b1014c5669b/orig
1073742464, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb40s43000c28d97a5hqwzk/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/7a20665f-d952-484a-86ef-b19399b703ae/orig
1073742466, https://avatars.mdst.yandex.net/get-media-adv-screenshooter/3091/ivb4gji6000cf86b22g4ca0u/orig, https://avatars.mds.yandex.net/get-media-adv-screenshooter/61268/398be4be-d15e-409d-ae64-2a57db2ec3a4/orig
