#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 мин",
  comment => "Расклейка доменов 100fit.ru и fitnessterra.ru"
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper 'Yandex::Log' => 'messages';
use ShardingTools qw/ppc_shards/;
use Settings;

$log->out('START');

my $DOMAIN_LIKE = '%100fit.ru';
my $MIRROR = '100fit.ru';

for my $shard (ppc_shards()) {
    $log->out("shard $shard");

    my $domains = get_one_column_sql(PPC(shard => $shard), "SELECT domain FROM filter_domain where domain like ?", $DOMAIN_LIKE);
    $log->out("selected domains: ", $domains);
    next unless @$domains;

    my $bids = get_one_column_sql(PPC(shard => $shard), ["SELECT bid FROM banners", WHERE => {reverse_domain => [map {scalar reverse $_} @$domains]}]);
    $log->out("selected ".scalar(@$bids)." bids: ", $bids);
    next unless @$bids;

    if (@$bids > 100_000) {
        $log->out("Too many banners for update");
    } else {
        my $updated = do_update_table(PPCDICT, 
                                      "mirrors", 
                                      {mirror => $MIRROR}, 
                                      where => {domain => $domains}
            );        
        $log->out("updated $updated mirrors");

        my $updated_domains = do_update_table(PPC(shard => $shard), 
                                      "filter_domain", 
                                      {filter_domain => $MIRROR}, 
                                      where => {domain => $domains}
            );        
        $log->out("updated $updated_domains domains");

        my $updated_banners = do_update_table(PPC(shard => $shard), "banners", 
                                              {statusBsSynced => 'No', LastChange__dont_quote => 'LastChange'}, 
                                              where => {bid => $bids}
            );
        $log->out("updated $updated_banners banners");
    }

    
}

$log->out('FINISH');

