#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 секунда на devtest"
}

=cut

use my_inc '..';

use Direct::Modern;

use Yandex::DBTools;
use Yandex::HashUtils;

use Primitives;
use ScriptHelper;
use Settings;
use JSON;


my @CLIENT_IDS_TO_FIX = (545763, 3151863, 34975);

sub fix_deleted_reps_for_clientid {
    my ($client_id) = @_;
    my $msg_prefix_guard = $log->msg_prefix_guard("[ClientID $client_id]");

    $log->out("Start fixing deleted_reps");
    my $reps = get_one_field_sql(PPC(ClientID => $client_id), "SELECT deleted_reps FROM clients WHERE ClientID = ?", $client_id);
    $log->out("Current deleted_reps: $reps");

    eval {
        JSON::from_json($reps);
    };
    if (!$reps || !$@) {
        $log->out("Nothing to fix");
        return;
    }

    my @uids_to_insert;
    for my $reps_part (split /,/, $reps) {
        $log->out("Checking part '$reps_part'");
        if ($reps_part =~ /"uid":"?(\d+)"?/) {
            $log->out("Found uid $1");
            push @uids_to_insert, $1;
        }
    }

    my @user_data_to_insert;
    for my $uid (@uids_to_insert) {
        my $info = hash_merge {uid=>$_}, {map {$_=>''} qw/fio phone email login/};
        hash_merge $info, get_info_by_uid_passport($uid);
        push @user_data_to_insert, $info;
    }

    my $user_data_to_insert_str = JSON::to_json(\@user_data_to_insert);
    $log->out("New deleted_reps: $user_data_to_insert_str");
    my $cnt = do_update_table(PPC(ClientID => $client_id), 'clients', {deleted_reps => $user_data_to_insert_str},
        where => {'ClientID' => $client_id, deleted_reps => $reps});
    $log->out("Succesfully updated $cnt records in clients table");
}

$log->out("START");
fix_deleted_reps_for_clientid($_) for @CLIENT_IDS_TO_FIX;
$log->out("FINISH");
