#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "пара секунд",
  comment => "Удаление лишних клиентов из таблицы client_currency_changes. Перед удалением проверяется, что клиент все еще в фишках"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;

use my_inc '..';

use ScriptHelper;
use Settings;

my @CLIENTS_TO_CLEAN = qw/
        2107242
        2802986
        3454733
        5353782
        5292377
        5478830
        7169299
        7979532
    /;

$log->out('START');

foreach_shard('ClientID' => \@CLIENTS_TO_CLEAN, sub {
    my ($shard, $client_ids) = @_;

    my $data_to_delete = get_all_sql(PPC(shard => $shard), ["
                                        SELECT ccc.*
                                        FROM client_currency_changes ccc
                                            LEFT JOIN clients c ON c.ClientID = ccc.ClientID",
                                        WHERE => {
                                            'ccc.ClientID' => $client_ids,
                                            _TEXT => "IFNULL(c.work_currency, 'YND_FIXED') = 'YND_FIXED'"
                                        }
                                    ]);

    $log->out("deleting ".scalar(@$data_to_delete)." clients from client_currency_changes on shard $shard:", $data_to_delete);
    my $affected_rows = do_delete_from_table(PPC(shard => $shard), 'client_currency_changes',
                                                where => {ClientID => [map {$_->{ClientID}} @$data_to_delete]}
                                            );
    $log->out("deleted $affected_rows clients");
});

$log->out('FINISH');
