#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "несколько минут",
  comment => 'запускать так 20161228_delete_banner_images_formats_and_pool.pl --data-file /var/www/ppc.yandex.ru/deploy/20161228_delete_banner_images_formats_and_pool.data'
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use Path::Tiny;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;

my $DRY_RUN = 0;
my $data_path;

extract_script_params(
    'dry-run' => \$DRY_RUN,
    'data-file=s' => \$data_path,
);

$log->out('START');

my @images_hashes = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");

for my $shard (ppc_shards()) {
    $log->out("shard: $shard");
    if ($DRY_RUN) {
        my $banners = get_all_sql(PPC(shard => $shard), [
            'select bi.image_hash, b.bid, c.cid, u.uid, u.login, u.email, u.lang, u.FIO, u.clientID 
             from banner_images bi 
                 join banners b on bi.bid = b.bid 
                 left join campaigns c on b.cid = c.cid 
                 left join users u on c.uid = u.uid ', 
             where => {'bi.image_hash' => \@images_hashes, 'b.statusArch' => 'No', 'c.archived' => 'No'}]);

        my ($result, $data) = ({}, {});
        my @fields = qw(login FIO email lang image_hash clientID uid cid bid);
        foreach my $banner (@$banners) {
            $data->{$banner->{uid}}->{$_}->{$banner->{$_}}++ for @fields;
        }
        foreach my $uid (keys %$data) {
            $result->{$uid}->{$_} = join(',', sort keys %{$data->{$uid}->{$_}}) for @fields;
        }

        $log->out(join("\t", @fields));
        foreach my $user (values %$result) {
            $log->out(join("\t", map {$user->{$_}} @fields));
        }
    } else {
        foreach my $table (qw/banner_images_pool banner_images_formats/) {
            my $rows_count = do_delete_from_table(PPC(shard => $shard), $table, where => {'image_hash' => [@images_hashes]});
            $log->out("deleted $rows_count rows from table $table");
        }
    }
}

$log->out('FINISH');
