#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 sec"
}

=cut

use my_inc '..';

use Direct::Modern;
use ScriptHelper;
use RBAC2::Extended;
use Campaign qw/create_campaigns_balance/;
use JSON qw/to_json/;
use Settings;
use Yandex::DBTools;
use RBACDirect qw/rbac_delete_campaign/;


my $wallet_cid = 19790945;
my $client_uid = 327396136;
my $new_wallet_cid = 21099021;
my $UID = 1;


$log->out("START");

do_delete_from_table(PPCDICT, 'shard_inc_cid', where => {cid => $wallet_cid});

my $rbac = eval { RBAC2::Extended->get_singleton($UID) } or $log->die("Error initialising RBAC: $@");
my $camp_balance_response = create_campaigns_balance($rbac, $UID, [$new_wallet_cid], force_group_order_transfer => 1);
if (! $camp_balance_response || $camp_balance_response->{error} || ! $camp_balance_response->{balance_res}) {
    $log->die("balance error " . to_json($camp_balance_response));
} else {
    my $rbac_error = eval {
        rbac_delete_campaign($rbac, $wallet_cid, $client_uid);
    };

    if ($@) {
        $log->out("rbac exception " . $@);
    } elsif ($rbac_error) {
        $log->out("rbac error " . $rbac_error);
    } else {
        $log->out("successfull delete rbac camp");
    }
}

$log->out("FINISH");
