#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
[
  {
    type          => 'sql',
    webstop       => "0",
    db            => "ppcdict",
    when          => 'before',
    time_estimate => "несколько секунд",
    sql           => q/ALTER TABLE trusted_redirects ADD opts SET('https_only', 'allow_wildcard') NOT NULL DEFAULT ''/,
  },
  {
    type          => 'script',
    when          => 'after',
    time_estimate => "на dev7 - 2-5 минут на шард",
    comment       => "Меняем у баннеров трекинговые ссылки на *.appmetrica.yandex.* на https://redirect.appmetrica.yandex.com. Можно останавливать и перезапускать в любой момент."
  }
]

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards qw/get_shard/;
use Yandex::URL;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;
use Primitives;

my $BID;
extract_script_params(
    'bid=i' => \$BID,
);

$log->out('START');

my $BANNERS_CHUNK_SIZE = 100;

for my $shard (defined $BID ? (get_shard(bid => $BID), ) : ppc_shards()) {
    my $msg_guard = $log->msg_prefix_guard("[shard_$shard]");

    # выбираем по href все подходящие баннеры РМП-кампаний
    my $banners = get_hashes_hash_sql(PPC(shard => $shard), [ 
        'SELECT STRAIGHT_JOIN b.bid, b.cid, b.href, b.domain, b.reverse_domain FROM campaigns c JOIN banners b USING (cid) ',
        WHERE => {
            'c.type' => 'mobile_content',
            'c.statusEmpty' => 'No',
            'b.href__like' => '%appmetri%yandex%',
            defined $BID ? ('b.bid' => $BID) : (),
        },
    ]);
    $log->out(sprintf("Тotal selected banners qty: %d", scalar(keys %$banners)));


    # проверяем что ссылки попадают под шаблон (в запросе проверка достаточно вольная)
    for my $bid (keys %$banners) {
        my $banner = $banners->{$bid};
        my $protocol = get_protocol($banner->{href});
        my $domain = get_host($banner->{href});
    
        if ($domain && $domain =~ /^(appmetri(c|k)a.yandex.(com|ru)|([^\.]+\.)?redirect.appmetrica.yandex.com)$/i) {
            # домен относится к яндексовой метрике приложений
            my $domain_ok = ($domain =~ /^([^\.]+\.)?redirect.appmetrica.yandex.com$/i ? 1 : 0);
            my $protocol_ok = ($protocol =~ m!^https://$!i ? 1 : 0);
            if ($domain_ok && $protocol_ok) {
                # протокол и домен уже такие как надо
                delete $banners->{$bid};
            } else {
                # финт чтоб оставить существующие домены вида 4.redirect.appmetrica.yandex.com как есть
                my $domain_new = $domain_ok ? $domain : 'redirect.appmetrica.yandex.com';

                $banner->{href_new} = $banner->{href} =~ s!^$protocol$domain!https://$domain_new!ri;
                $banner->{domain_new} = $domain_new;
                $banner->{reverse_domain_new} = reverse_domain($banner->{domain_new});
            }
        } else {
            delete $banners->{$bid};
        }
    }

    $log->out("Total banners to update: " . scalar(keys %$banners));
    my $total_banners_updated = 0;
    for my $bids_chunk (chunks([keys %$banners], $BANNERS_CHUNK_SIZE)) {
        my @banners_chunk = map { $banners->{$_} } @$bids_chunk;
        $log->out(sprintf("Banners chunk to update (qty=%d):", scalar(@banners_chunk)), 
                  map { +{%$_, 'state' => 'before_update'} } @banners_chunk);

        my $updated_qty = 0;
        relaxed sub {
            $updated_qty += do_update_table(PPC(shard => $shard), 'banners', {href__dont_quote => sql_case('bid', { map { $_->{bid} => $_->{href_new} } @banners_chunk }),
                                                                              domain__dont_quote => sql_case('bid', { map { $_->{bid} => $_->{domain_new} } @banners_chunk }),
                                                                              reverse_domain__dont_quote => sql_case('bid', { map { $_->{bid} => $_->{reverse_domain_new} } @banners_chunk }),
                                                                              statusBsSynced => 'No'},
                                                                    where => {bid => $bids_chunk,
                                                                              href__dont_quote => sql_case('bid', { map { $_->{bid} => $_->{href} } @banners_chunk })});
        };
        $total_banners_updated += $updated_qty;
        $log->out("Successfully updated $updated_qty banners");
        my $banners_after_update = get_all_sql(PPC(shard => $shard), ['select bid, href, domain, reverse_domain
                                                                         from banners',
                                                                        where => {bid => $bids_chunk}]);
        $log->out(map { +{%$_, 'state' => 'after_update'} } @$banners_after_update);
    }
    $log->out("Total updated banners: " . $total_banners_updated);
}

$log->out('FINISH');
