#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
[
  {
    type => 'manual',
    when => 'after',
    time_estimate => "несколько минут",
    text => "проверить, что на всех ppcscripts не запущен скрипт ppcCalcIsBSRarelyLoaded.pl, если запущен - прибить"
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "несколько секунд",
    comment => "запускать с любого из ppcscripts"
  }
]

=cut

use Direct::Modern;

use Yandex::YT::Table;

use my_inc '..';

use ScriptHelper;
use Settings;
use Tools;

$log->out('START');

$log->out("setup env");
Tools::force_set_yt_environment("banach");

my $old_snap = Yandex::YT::Table->new("//home/direct/export/bs_load_probability");
my $new_snap = Yandex::YT::Table->new("//home/direct/tmp/bs_load_probability");
my $diff = Yandex::YT::Table->new("//home/direct/export/bs_load_probability_snapshots_diff");

$log->out("check exists old snapshot " . $old_snap->node_name());
if ($old_snap->exists()) {
    my $move_to = Yandex::YT::Table->new("//home/direct/tmp/bs_load_probability.old.to_delete");
    $log->out("remove to " . $move_to->node_name());
    $old_snap->move($move_to);
    $log->out("moved");
} else {
    $log->out("old snapshot doens't exists, skip");
}

$log->out("check exists new snapshot " . $new_snap->node_name());
if ($new_snap->exists()) {
    my $move_to = Yandex::YT::Table->new("//home/direct/tmp/bs_load_probability.new.to_delete");
    $log->out("remove to " . $move_to->node_name());
    $new_snap->move($move_to);
    $log->out("moved");
} else {
    $log->out("new snapshot doens't exists, skip");
}

$log->out("check exists diff " . $diff->node_name());
if ($diff->exists()) {
    my $move_to = Yandex::YT::Table->new("//home/direct/tmp/bs_load_probability_snapshots_diff.to_delete");
    $log->out("remove to " . $move_to->node_name());
    $diff->move($move_to);
    $log->out("moved");
} else {
    $log->out("diff doens't exists, skip");
}

$log->out('FINISH');

