#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr

{
    type => 'script',
    when => 'after',
    time_estimate => 'несколько минут на devtest',
}

=cut

use my_inc "..";

use Direct::Modern;

use Path::Tiny;

use ScriptHelper;
use Settings;
use Primitives;
use Client;
use Currencies;
use Yandex::DBTools;
use List::MoreUtils qw/none/;

=head2 set_country

    Функция для простановки страны. Делает простановку только если страна корректна для клиента. Код проверки скопирован из
    Staff::save_edited_user

=cut

sub set_country {
    my ($client_id, $country, $currency) = @_;

    my %client_data_updates;
    my %client_data_updates_balance;

    my $country_currencies;
    my $agency_id = Primitives::get_client_first_agency($client_id);
    if ($agency_id) {
        # для агентств и субклиентов - берем агентсткие страны/валюты
        $country_currencies = Currencies::get_currencies_by_country_hash_for_agency();
    } else {
        # для остальных (самостоятельные, сервисируемые) - неагентсткие
        $country_currencies = Currencies::get_currencies_by_country_hash_not_for_agency();
    }

    if (!defined $country || ($country > 0 && !exists $country_currencies->{$country})) {
        $log->out("Unacceptable country: %s", $country);
        return;
    }
    $client_data_updates{country_region_id} = $country;
    $client_data_updates_balance{REGION_ID} = $country;

    my $currencies = $country_currencies->{$country};
    if (!$currency || ((!is_valid_currency($currency) || none {$_ eq $currency} @$currencies) && $currency ne 'YND_FIXED')) {
        $log->out("Unacceptable currency: %s", $currency);
        return;
    }
    $client_data_updates{work_currency} = $currency;
    if ($currency ne 'YND_FIXED') {
        $client_data_updates_balance{CURRENCY} = $currency;
        $client_data_updates_balance{MIGRATE_TO_CURRENCY} = Client::get_client_migrate_to_currency($client_id);
    }

    create_update_client({client_data => {ClientID => $client_id, %client_data_updates}});
    my $is_error = update_client_id(1, $client_id, \%client_data_updates_balance);
    $log->out('Error while updating balance data') if $is_error;
}

my $data_path;
extract_script_params(
    'data-file=s' => \$data_path,
);
$data_path //= my_inc::path('./20170126_set_customer_country.data');

$log->out('START');
my @uid2reg_lines = path($data_path)->lines({ chomp => 1}) or $log->die("Can't open data file $data_path: $@");

for my $line (@uid2reg_lines) {
    my ($uid, $country_region_id) = split(';', $line);
    my $msg_prefix_guard = $log->msg_prefix_guard("[uid_$uid]");

    $log->out("Region to set: $country_region_id");
    my $client_data = get_one_line_sql(PPC(uid => $uid),
        "SELECT cl.ClientID, cl.country_region_id, IFNULL(cl.work_currency, 'YND_FIXED') as currency
           FROM clients cl
                JOIN users u ON u.ClientID = cl.ClientID
          WHERE u.uid = ?
        ", $uid);
    unless ($client_data && %$client_data) {
        $log->out("Cannot find client with uid");
        next;
    }

    $log->out("Current country id: $client_data->{country_region_id}, currency: $client_data->{currency}");
    if ($client_data->{country_region_id}) {
        $log->out("Skipping user because country is already set");
        next;
    }

    set_country($client_data->{ClientID}, $country_region_id, $client_data->{currency});
}

$log->out('FINISH');
