#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "15-20 минут"
}

=cut

use Direct::Modern;

use Yandex::ListUtils;
use Yandex::Shell;

use my_inc '..';

use ScriptHelper;
use Settings;

my $script_path = my_inc::path('../protected/one-shot/fix-bs_order_target_stat-data.pl');
my $data_path = my_inc::path('./20170130_refresh_bs_order_target_stat_for_some_orders.data');

my $orders;
my $date = "20170119";

$log->out( 'START' );

$log->out( "load orders for refresh from file $data_path" );
open (my $fh, '<', $data_path) or $log->die( "Error opening file: $!" );
my $cnt = 0;
while (my $line = <$fh>) {
    if ($line =~ m/^(\d+)$/) {
        push @$orders, $1;
        $cnt++;
    } else {
        $log->out( "invalid data line: $line" );
    }
}
close ($fh) or $log->die( "Error closing file: $!" );

$log->out( "Got $cnt orders to refresh" );

for my $orders_chunk (chunks($orders, 100)) {
    $log->out( { date_from => $date, date_to => $date, OrderID => $orders_chunk } );
    my $ret = eval {
        yash_system($script_path, '--fix', '--order-chunk' => 20, '--from' => $date, '--to', $date,
            map { ('--orderid' => $_) } @$orders_chunk);
        return 1;
    };
    $log->out( !$ret || $@ ? 'ERROR' : 'OK' );
}

$log->out( 'FINISH' );

