#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 часа",
  comment => "скрипт можно убивать и перезапускать"
}

=cut

use Direct::Modern;

use Yandex::Retry;
use Yandex::DBTools;

use my_inc '..';

use ShardingTools;
use ScriptHelper;
use Settings;

my $LIMIT = 2000;

$log->out('START');

for my $shard (ppc_shards()) {
    update_in_shard($shard);
}

$log->out('FINISH');



sub update_in_shard {
    my ($shard) = @_;
    my $g = $log->msg_prefix_guard("[shard=$shard]");
    my $max_cid = get_one_field_sql(PPC(shard=>$shard), "SELECT max(cid) FROM campaigns");
    my $min_cid = 0;
    while($min_cid <= $max_cid) {
        my $g = relaxed_guard(times => 1);
        $log->out("select wrong camps with cid >= $min_cid");
        my $rows = get_all_sql(PPC(shard => $shard), "SELECT STRAIGHT_JOIN c.cid, u.ClientID
                                                        FROM campaigns c
                                                             JOIN users u using(uid) 
                                                       WHERE c.cid between ? and ? 
                                                         AND ifnull(c.ClientID, 0) = 0
                                                       ORDER BY c.cid
                                                       LIMIT $LIMIT", $min_cid, $max_cid);
        $log->out($rows);
        last if !@$rows;
        do_mass_update_sql(PPC(shard => $shard), 'campaigns', 'cid',
                           {map {$_->{cid} => {ClientID => $_->{ClientID}}} @$rows}
            );
        $min_cid = $rows->[-1]->{cid} + 1;
    }
}
