#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "час на каждый шард",
  comment => "Выставляем умолчальные значения для autobudgetPriority
Можно запускать на ТС, перезапускать, указывать --sleep-coef
  "
}

=cut

use Direct::Modern;

use Yandex::DBTools;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools qw/ppc_shards/;
use Yandex::Retry qw/relaxed_guard/;

my $SLEEP_COEF = 1;
extract_script_params(
    "sleep-coef=s" => \$SLEEP_COEF,
);

$log->out('START');

my $chunk = 10_000;
SHARD: for my $shard (ppc_shards()) {
    my $mpg = $log->msg_prefix_guard("[shard $shard]");
    my ($min_cid, $max_cid) = get_one_line_array_sql(PPC(shard => $shard), "select min(cid), max(cid) from campaigns");
    while ($min_cid <= $max_cid) {
        $log->out("cid = $min_cid / $max_cid");
        my $rg = relaxed_guard times => $SLEEP_COEF;
        my $rows = int do_sql(PPC(shard => $shard), [
            "update bids join campaigns c on c.cid = bids.cid
            set autobudgetPriority = 3",
            where => {
                autobudgetPriority__is_null => 1,
                autobudget => 'Yes',
                'c.cid__between' => [ $min_cid, $min_cid + $chunk - 1 ],
            }
        ]);
        $log->out("$rows rows updated");
        # last SHARD if $rows;
        $min_cid += $chunk;
    }
}

$log->out('FINISH');

