#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "5 сек"
}

=cut

use Direct::Modern;

use Path::Tiny qw/path/;
use JSON;

use Yandex::DBTools;
use Yandex::IDN qw/idn_to_ascii/;

use my_inc '..';

use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;

$log->out('START');

my $data_file = path(my_inc::path('./20170228_correct_mirrors_corrections.data'));
my $data = from_json($data_file->slurp_utf8);

my @rows = map {[idn_to_ascii($_->[0]), idn_to_ascii($_->[1]), 'Auto']} @$data;

$log->out("row for insert: ".to_json($_)) for @rows;

my $res = do_mass_insert_sql(PPCDICT, "INSERT IGNORE INTO mirrors_correction (domain, redirect_domain, correction_type) VALUES %s", \@rows);
$log->out("inserted $res rows");

$log->out('FINISH');

