#!/usr/bin/perl

=head1 DEPLOY

# approved by hmepas
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 мин на devtest"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ShardingTools;
use ScriptHelper;
use Settings;

$log->out('START');

for my $shard (ppc_shards()) {

    my $ids = get_one_column_sql(PPC(shard => $shard), 'select id from bids where cid = 0 and phrase = ""');
    $log->out("select empty bids with id: ".join(',' => @$ids));

    for my $chunk (chunks $ids, 1_000) {
      do_delete_from_table(PPC(shard => $shard), 'bids', where => {id => $chunk});
    }
}

$log->out('FINISH');

