#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "20 секунд на devtest",
  comment => 'можно запускать повторно',
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use JSON;

use my_inc '..';

use ShardingTools;
use ScriptHelper;
use Settings;

$log->out('START');

my @shards = ppc_shards();
# @shards = (4 .. 9);

for my $shard (@shards) {
    $log->out("SHARD #$shard");

    state $bt_by_ft = {
        auto => 'AutoRu',
        flights => 'GoogleFlights',
        hotels => [ 'GoogleHotels', 'TravelBooking' ],
        realty => 'YandexRealty',
    };

    for my $business_type (keys %$bt_by_ft) {
        my $feed_ids = get_one_column_sql(PPC(shard => $shard), [
                'SELECT feed_id FROM feeds',
                WHERE => {
                    feed_type => $bt_by_ft->{$business_type},
                    business_type__ne => $business_type,
                },
            ]);
        next if !@$feed_ids;

        $log->out("Set business_type='$business_type' for feed_id=(@$feed_ids)");
        do_update_table(PPC(shard => $shard), feeds => { business_type => $business_type },
            where => { feed_id => $feed_ids }
        );
    }


    state $feed_types = [qw/
        AutoRu YandexRealty GoogleFlights GoogleMerchant
        YandexZen
        GoogleHotels TravelBooking
        AliExpress Alibaba
        CriteoTurkey TurkeyJollyTur TurkeyTeknosa TurkeyClient1
    /];

    my $pfilters = get_all_sql(PPC(shard => $shard), [
            'SELECT perf_filter_id, condition_json, feed_type, cid
            FROM bids_performance
            JOIN adgroups_performance USING(pid)
            JOIN phrases p using(pid)
            JOIN feeds USING(feed_id)',
            WHERE => {
                feed_type => $feed_types,
            },
        ]);

    my %pupdate;
    my %pcids;
    my %ptab;
    for my $filter (@$pfilters) {
        my $id = $filter->{perf_filter_id};
        push @{$pcids{$filter->{cid}}}, $id;

        my $old_condition = $filter->{condition_json};
        my $new_condition = _clean_condition($old_condition, $filter->{feed_type});
        $ptab{$id} = $new_condition eq '{}' ? 'all-products' : 'condition';

        if ($new_condition ne $old_condition) {
            $log->out("Condition cleanup for perf_filter_id=$id: $old_condition -> $new_condition");
            $pupdate{$id} = {condition_json => $new_condition};
        }
    }

    if (%pupdate) {
        do_mass_update_sql(PPC(shard => $shard), bids_performance => perf_filter_id => \%pupdate);
    }

    if (%pcids) {
        my $cso = get_all_sql(PPC(shard => $shard), [
                'SELECT cid, options  FROM camp_secondary_options',
                WHERE => {
                    key => 'perf_filter:from_tab',
                    cid => [keys %pcids],
                },
            ]);
        for my $item (@$cso) {
            my $cid = $item->{cid};
            my $old_options = $item->{options};
            my $options = from_json $old_options;
            my $filter_ids = $pcids{$cid};
            for my $filter_id (@$filter_ids) {
                $options->{$filter_id} = $ptab{$filter_id}  if ($options->{$filter_id} || '') ne 'condition';
            }
            my $new_options = to_json $options, {canonical => 1};
            next if $new_options eq $old_options;

            $log->out("Updating from_tab for cid=$cid, perf_filter=(@$filter_ids)");
            do_update_table(PPC(shard => $shard), 'camp_secondary_options',
                {options => $new_options},
                where => {cid => $cid, key => 'perf_filter:from_tab'},
            );
        }
    }


    my $dfilters = get_all_sql(PPC(shard => $shard), [
            'SELECT dyn_cond_id, condition_json, feed_type, cid
            FROM dynamic_conditions
            JOIN adgroups_dynamic USING(pid)
            JOIN phrases p using(pid)
            JOIN feeds USING(feed_id)',
            WHERE => {
                feed_type => $feed_types,
            },
        ]);

    my %dupdate;
    my %dcids;
    my %dtab;
    for my $filter (@$dfilters) {
        my $id = $filter->{dyn_cond_id};
        push @{$dcids{$filter->{cid}}}, $id;
        my $old_condition = $filter->{condition_json};
        my $new_condition = _clean_condition($old_condition, $filter->{feed_type});
        $dtab{$id} = $new_condition eq '{}' ? 'all-products' : 'condition';
        next if $new_condition eq $old_condition;

        $log->out("Condition cleanup for dyn_cond_id=$id: $old_condition -> $new_condition");
        $dupdate{$id} = {condition_json => $new_condition};
    }

    if (%dupdate) {
        do_mass_update_sql(PPC(shard => $shard), dynamic_conditions => dyn_cond_id => \%dupdate);
    }

    if (%dcids) {
        my $cso = get_all_sql(PPC(shard => $shard), [
                'SELECT cid, options  FROM camp_secondary_options',
                WHERE => {
                    key => 'dyn_cond:from_tab',
                    cid => [keys %dcids],
                },
            ]);
        for my $item (@$cso) {
            my $cid = $item->{cid};
            my $old_options = $item->{options};
            my $options = from_json $old_options;
            my $filter_ids = $dcids{$cid};
            for my $filter_id (@$filter_ids) {
                $options->{$filter_id} = $dtab{$filter_id}  if ($options->{$filter_id} || '') ne 'condition';
            }
            my $new_options = to_json $options, {canonical => 1};
            next if $new_options eq $old_options;

            $log->out("Updating from_tab for cid=$cid, dyn_cond=(@$filter_ids)");
            do_update_table(PPC(shard => $shard), 'camp_secondary_options',
                {options => $new_options},
                where => {cid => $cid, key => 'dyn_cond:from_tab'},
            );
        }
    }


    my $creatives = get_all_sql(PPC(shard => $shard), [
            'SELECT creative_id, c.ClientID,
                c.business_type,
                group_concat(distinct f.business_type) as feed_business_type
            FROM perf_creatives c
            JOIN banners_performance USING(creative_id)
            JOIN adgroups_performance USING(pid)
            JOIN feeds f USING(feed_id)
            WHERE c.creative_type = "performance"
            GROUP BY creative_id
            HAVING c.business_type!=feed_business_type'
        ]);

    my $off_creatives = get_all_sql(PPC(shard => $shard), [
            'SELECT creative_id, business_type, template_id
            FROM perf_creatives c
            LEFT JOIN banners_performance bp USING(creative_id)
            WHERE c.creative_type = "performance"
            AND bp.creative_id IS NULL'
        ]);

    my %update;
    for my $item (@$creatives) {
        my $creative_id = $item->{creative_id};
        my $new_type = $item->{feed_business_type};
        if ($new_type =~ /,/) {
            $log->out("WARNING: creative_id=$creative_id (ClientID=$item->{ClientID}) has ambigous type: $new_type");
            next;
        }

        push @{$update{$new_type}}, $creative_id;
    }

    for my $item (@$off_creatives) {
        state $type_by_template = {
            (map {$_ => 'realty'}   qw/ 748 755 756 757 758 759 760 /),
            (map {$_ => 'hotels'}   qw/ 619 620 684 /),
            (map {$_ => 'news'}     qw/ 771 772 /),
            (map {$_ => 'flights'}  qw/ 812 813 814 815 816 817 818 819 /),
        };

        my $new_type = $type_by_template->{$item->{template_id}};
        next if !$new_type || $new_type eq $item->{business_type};

        push @{$update{$new_type}}, $item->{creative_id};
    }

    for my $new_type (keys %update) {
        my $ids = $update{$new_type};
        $log->out("Setting business_type=$new_type for creative_id=(@$ids)");
        do_update_table(PPC(shard => $shard), perf_creatives => { business_type => $new_type },
            where => { creative_id => $ids }
        );
    }

}

$log->out('FINISH');


sub _clean_condition {
    my ($json, $feed_type) = @_;

    my $cond = from_json($json || '{}');
    delete $cond->{"categoryId =="};

    if ($feed_type eq 'AutoRu') {
        $cond->{availability} = "в наличии"  if delete $cond->{available};
        _replace_key($cond, vendor => 'mark_id');
    }
    elsif ($feed_type eq 'GoogleMerchant') {
        $cond->{availability} = "in stock"  if delete $cond->{available};
        _replace_key($cond, vendor => 'brand');
        _replace_key($cond, url => 'link');
    }
    elsif ($feed_type eq 'GoogleHotels') {
        _replace_key($cond, price => 'Price');
    }

    return to_json $cond, {canonical => 1};
}

sub _replace_key {
    my ($cond, $key_from, $key_to) = @_;

    for my $key (keys %$cond) {
        my $new_key = $key =~ s/^$key_from\b/$key_to/r;
        next if $new_key eq $key;
        $cond->{$new_key} = delete $cond->{$key};
    }

    return;
}
