#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 c",
  comment => "Удаление неподдерживаемых групп"
}

=cut

use my_inc "..";

use Direct::Modern;
use Settings;
use Models::AdGroup qw//;
use Models::Banner qw//;
use ScriptHelper 'Yandex::Log' => 'messages';

my @UNSUPPORTED_PIDS = (2570593352, 2570598979);
my $CID = 26440654;

$log->out("START");

my $banners = Models::Banner::get_banners_for_delete({pid => \@UNSUPPORTED_PIDS});
$log->out("selected bids to delete " . join ",", map { $_->{bid} } @$banners);
my ($qty, $error) = Models::Banner::delete_banners($CID, $banners, {skip_checks => 1});
$log->out("delete $qty banners");
$log->out("was errors $error") if $error;
Models::AdGroup::delete_groups([map { { cid => $CID, pid => $_ } } @UNSUPPORTED_PIDS]);
$log->out("delete adgroups");

$log->out("FINISH");
