#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 мин",
  comment => "создаёт в clients недостающие записи"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::DBShards;
use Yandex::Retry qw/relaxed/;

use my_inc '..';

use ScriptHelper 'Yandex::Log' => 'messages';
use ShardingTools qw/ppc_shards/;
use Settings;

my $CHUNK_SIZE = 1000;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("shard=$shard");
    my $ClientIDS = get_one_column_sql(PPC(shard => $shard), "
                            SELECT u.ClientID
                              FROM users u 
                                   LEFT JOIN clients c ON c.ClientID = u.ClientID
                             WHERE c.ClientID is null");
    while(my @chunk = splice @$ClientIDS, 0, $CHUNK_SIZE) {
        my $client2shard = get_shard_multi(ClientID => \@chunk);
        if (my @bad = grep {!defined $client2shard->{$_} || $client2shard->{$_} != $shard} @chunk) {
            $log->out("Incorrect shard clients: ".join(',', map {"$_:".($client2shard->{$_} // 'undef')} @bad));
        }
        
        if (my @good = grep {defined $client2shard->{$_} && $client2shard->{$_} == $shard} @chunk) {
            $log->out("Insert rows for clients: ".join(',', @good));
            relaxed times => 1, sub {
                do_mass_insert_sql(PPC(shard => $shard), 
                                   "INSERT IGNORE INTO clients (ClientID, work_currency) VALUES %s", 
                                   [map {[$_, 'YND_FIXED']} @good]
                    );
            };
        }
    }
}

$log->out('FINISH');

