#!/usr/bin/perl

=head1 DEPLOY

# approved by liosha
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "1 мин на devtest"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;

use my_inc '..';

use ShardingTools;
use ScriptHelper;
use Settings;

$log->out('START');

my @shards = ppc_shards();

for my $shard (@shards) {

    my $mbids = get_one_column_sql(PPC(shard => $shard), [
            "SELECT DISTINCT mbid
            FROM mediaplan_bids_retargeting
            LEFT JOIN mediaplan_banners mb USING(mbid)
            WHERE mb.mbid IS NULL"
        ]);
    $log->out("shard #$shard: under-deleted mbids ".join(',' => @$mbids));

    for my $chunk (chunks $mbids, 1_000) {
        do_delete_from_table(PPC(shard => $shard), 'mediaplan_bids_retargeting', where => {mbid => $chunk});
    }
}

$log->out('FINISH');

