#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "10 минут на devtest",
  comment => "скрипт можно перезапускать"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;

use my_inc '..';

use TimeTarget;
use ShardingTools qw/ppc_shards/;
use ScriptHelper;
use Settings;

my $CHUNK_SIZE = 1_000;

$log->out('START');

for my $shard (ppc_shards()) {
    $log->out("process shard $shard");
    my $camps = get_all_sql(PPC(shard => $shard),
        "SELECT cid, timeTarget FROM campaigns WHERE length(timeTarget) = 31 and timeTarget rlike '^[0-9-]{7}[A-X-]{24}\$'");
    $log->out("going to upgrade timeTarget for ".(scalar @$camps)." campaigns");

    # структура: old_timeTarget -> {cids => [], timeTarget => new_timeTarget}
    my %update;
    for my $row (@$camps) {
        my $old = $row->{timeTarget};
        my $new = TimeTarget::pack_timetarget(TimeTarget::parse_timetarget($old));
        next if $new eq $old;
        my $update_item = $update{$old} ||= {cids => [], timeTarget => $new};
        push @{$update_item->{cids}}, $row->{cid};
    }
    for my $old (sort(keys %update)) {
        my $update_item = $update{$old};

        while(my @cids = splice @{$update_item->{cids}}, 0, $CHUNK_SIZE) {
            my $guard = relaxed_guard times => 1; # спим столько же, сколько длился update
            my $new = $update_item->{timeTarget};
            my $updated = do_update_table(PPC(shard => $shard), "campaigns",
                {
                    timeTarget => $new
                },
                where => {
                    cid => \@cids,
                    timeTarget => $old,
                }
            );
            $log->out("update timeTarget '$old' => '$new', rows=".scalar(@cids).", updated=$updated, cids=".join(", ", @cids));
        }
    }
}

$log->out('FINISH');

