#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "40 секунд",
  comment => "Проставляем statusEasy='No' записям в users_options без записи в users"
}

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Yandex::Retry qw/relaxed_guard/;

use my_inc '..';

use ScriptHelper;
use Settings;

use ShardingTools qw/ppc_shards/;

my $SLEEP_COEF = 1;

$log->out('START');

foreach my $shard (ppc_shards()) {
    my $msg_prefix_guard = $log->msg_prefix_guard("[shard $shard]");
    # uid-ы для которых есть запись в users_options, но нет в users co statusEasy = 'Yes'
    my $bad_uids = get_one_column_sql(PPC(shard => $shard),
       "SELECT uo.uid FROM users_options uo
        LEFT JOIN users u ON u.uid=uo.uid
        WHERE u.uid IS NULL AND statusEasy = 'Yes'");
    if (@$bad_uids) {
        $log->out('Got '. scalar @$bad_uids .' uids for set statusEasy=No:');
        $log->out({bad_uids => $bad_uids});
        foreach my $bad_uids_chunk (chunks($bad_uids, 1000)) {
            my $relax = relaxed_guard(times => $SLEEP_COEF);
            do_update_table(PPC(shard => $shard), 'users_options', {statusEasy => 'No'}, where => { uid => $bad_uids_chunk, statusEasy => 'Yes'});
        }
    } else {
        $log->out("No clients for set statusEasy=No");
    }
    $log->out("Done");
}

$log->out('FINISH');

