#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "до часа на одном шарде на devtest",
  comment => "проставить пустым группам статус черновик"
}

=cut

use my_inc "..";

use Direct::Modern;
use Settings;
use Models::AdGroup qw//;
use ScriptHelper 'Yandex::Log' => 'messages';
use Yandex::DBTools;
use ShardingTools qw/foreach_shard_parallel_verbose/;

$log->out("START");
my $MAX_ROWS_COUNT = 25000;

my $SHARD;
extract_script_params(
    'shard-id=i' => \$SHARD,
);


foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;

    return if ($SHARD && $shard != $SHARD);
    $log->out("SHARD #$shard");

    my $statuses = ["Sent", "Sending", "Ready"];
    my ($max_pid) = get_one_line_array_sql(PPC(shard => $shard), "select max(pid) from phrases");

    foreach my $table (qw/phrases banners/) {
        $log->out("table: $table");
        my $last_pid = 0;
 
        while ($last_pid < $max_pid) {
            $log->out("pid = $last_pid / $max_pid");
 
            my $group_ids = get_one_column_sql(PPC(shard => $shard), [
                "SELECT distinct pid FROM $table", 
                 WHERE => {'statusModerate' => $statuses, 'pid__gt' => $last_pid, 'pid__le' => $max_pid},
                "ORDER BY pid LIMIT $MAX_ROWS_COUNT", 
            ]);
            $log->out("groups count: " . scalar(@$group_ids));
 
            last unless scalar(@$group_ids) > 0;
            $last_pid = $group_ids->[-1];

            update_statusModerate($shard, $group_ids);
        }
    }
});

sub update_statusModerate {
    my ($shard, $chunk) = @_;
    my $completed_groups = Models::AdGroup::is_completed_groups($chunk);
 
    my $group_ids = [grep { !$completed_groups->{$_} } @$chunk];
    my $bids = get_one_column_sql(PPC(shard => $shard), ['select bid from banners', WHERE => {pid => $group_ids}]);
    $log->out("empty groups count: " . scalar(@$group_ids));

    do_in_transaction {

        do_update_table(PPC(shard => $shard), 'phrases', {
                statusModerate => 'New',
                statusPostModerate => 'No',
                LastChange__dont_quote => 'LastChange',
            },
            where => {pid => $group_ids}
        );
  
        do_update_table(PPC(shard => $shard), 'banners', {
                statusModerate => 'New',
                phoneflag => 'New',
                statusSitelinksModerate => 'New',
                statusPostModerate => 'No',
                LastChange__dont_quote => 'LastChange',
            },
            where => {bid => $bids}
        );
  
        do_update_table(PPC(shard => $shard), 'banner_images', {
                statusModerate => 'New',
                date_added__dont_quote => 'date_added',
            },
            where => {bid => $bids}
        );
  
        do_update_table(PPC(shard => $shard), 'banners_performance', {
                statusModerate => 'New',
            },
            where => {bid => $bids}
        );
    };
}

$log->out("FINISH");
