#!/usr/bin/perl

=head1 DEPLOY

# approved by zhur
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "9 часов",
  comment => "можно перезапускать"
}

=cut

use Direct::Modern;
use Getopt::Long;

use Yandex::Retry qw/relaxed_guard/;

use my_inc '..';

use ScriptHelper 'Yandex::Log' => 'messages';
use Settings;
use DirectRedis;

# проставить всем ключам в Redis expire 25 часов

my $MASK = "units-*";
my $CHUNK_SIZE = 10_000;
my $ITER_NUM = undef;
my $SLEEP_COEF = 2.0;
my $EXPIRE = 25*60*60;
GetOptions(
    "mask=s" => \$MASK,
    "expire=i" => \$EXPIRE,
    "chunk-size=i" => \$CHUNK_SIZE,
    "iter-num=i" => \$ITER_NUM,
    "sleep-coef=f" => \$SLEEP_COEF,
    ) || die $!;

$log->out('START');

my $rc = DirectRedis::get_redis();
for my $slot (@{$rc->_get_slots()}) {
    my $r = $rc->_get_master_by_slot($slot->[0]);
    my $g = $log->msg_prefix_guard("server=".$r->{server});

    my $iter = 0;
    my $cursor = 0;
    while(1) {
        my $rg = relaxed_guard times => $SLEEP_COEF;
        my $ret = $r->scan($cursor, MATCH => $MASK, COUNT => $CHUNK_SIZE);
        $cursor = $ret->[0];
        my $keys = $ret->[1];
        $iter++;
        $log->out("iter: $iter, get ".scalar(@$keys)." keys");

        for my $key (@$keys) {
            $r->expire($key, $EXPIRE, sub {});
        }
        $r->wait_all_responses();

        if (!$cursor) {
            $log->out("no more data, exit");
            last;
        }
        if ($ITER_NUM && $iter >= $ITER_NUM) {
            $log->out("Iteration limit exceeded, exit");
            last;            
        }
    }
}

$log->out('FINISH');

