#!/usr/bin/perl

use my_inc '..';

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 часа на devtest",
  comment => "Перед запуском сделать
        scp ppcdev5.yandex.ru:/home/buhter/20170622_old_avatars_banners_to_stop.data /tmp
	Запускать так: ./deploy/20170622_old_avatars_banners_to_stop.pl --data=/tmp/20170622_old_avatars_banners_to_stop.data
	Можно прибивать и перезапускать; если успеет обработать много — можно удалить из файла обработанные bid-ы
	"
}

=cut

use warnings;
use strict;
use utf8;

use BS::ResyncQueue;
use Yandex::DBTools;
use Yandex::ListUtils;
use Yandex::Retry qw/relaxed/;
use Path::Tiny;

use Settings;
use ScriptHelper;

$log->out('START');

my $SLEEP_COEF = 1;
my $data_path = "/tmp/20170622_old_avatars_banners_to_stop.data";

extract_script_params(
    'data=s', \$data_path,
);

my @bids = path($data_path)->lines({ chomp => 1 }) or $log->die("Can't open data file $data_path: $@");
$log->out("Got ".scalar(@bids)." banners to stop in total");

for my $bids_chunk (chunks(\@bids, 5_000)) {
    relaxed times => $SLEEP_COEF, sub {
            $log->out("Got ".scalar(@$bids_chunk)." banners to stop in chunk");
            my $priority = 70;
            my $resync = get_all_sql(PPC(bid => $bids_chunk),
                [ "Select cid, pid, bid, $priority as priority from banners", where => { bid => $bids_chunk, 'statusShow' => 'Yes' } ]);
            $log->out("Going to stop bids: @$bids_chunk");
	    do_update_table(PPC(bid => $bids_chunk), 'banners',
                { statusShow               => 'No',
                    LastChange__dont_quote => 'NOW()',
                },
                where => { bid => $bids_chunk, 'statusShow' => 'Yes' });
            $log->out("Bids stopped: @$bids_chunk");
            bs_resync($resync);
            $log->out("Added to resync queue ".scalar(@$resync));
	}
}
$log->out('FINISH');
