#!/usr/bin/perl

=head1 DEPLOY

# approved by hrustyashko 
# .migr
    {
        type => 'script',
        when => 'after',
        time_estimate => 'на devtest: около часа на шард',
        comment => 'заменяем пустой гео на 0'
    }

=cut

use Direct::Modern;

use my_inc '..';

use Settings;
use ShardingTools qw/foreach_shard_parallel_verbose/;
use ScriptHelper;
use Yandex::DBTools;
use Yandex::Retry qw/relaxed_guard/;


my $SLEEP_TIME_COEF = 1;
my $CLIENTID;
my $SHARD;

extract_script_params(
    'shard=i' => \$SHARD,
    'sleep-coef' => \$SLEEP_TIME_COEF,
);
$log->out('START');

my $chunk = 10_000_000;
foreach_shard_parallel_verbose($log, sub {
    my $shard = shift;
    return if defined $SHARD && $SHARD != $shard;

    my $log_prefix_guard = $log->msg_prefix_guard("shard $shard:");
    my ($min_pid, $max_pid) = get_one_line_array_sql(PPC(shard => $shard), "select min(pid), max(pid) from phrases");

    while ($min_pid <= $max_pid) {
        $log->out("pid = $min_pid / $max_pid");

        my $rg = relaxed_guard(times => $SLEEP_TIME_COEF);
        my $pids = get_one_column_sql(PPC(shard => $shard), ["SELECT pid FROM phrases",
            where => {
                _OR => {geo__is_null => 1, geo => ''},
                'pid__between' => [ $min_pid, $min_pid + $chunk - 1 ], 
            }
        ]);

        if (@$pids) {
            my $rows_count = int do_sql(PPC(shard => $shard), [
                "UPDATE phrases SET geo='0'",
                where => {_OR => {geo__is_null => 1, geo => ''}, 'pid' => $pids}
            ]);
            $log->out("phrases: $rows_count rows updated");
        }
        $min_pid += $chunk;
    }
    my $cids = get_one_column_sql(PPC(shard => $shard), "SELECT cid FROM campaigns WHERE geo = ''");
    my $rows_count = int do_sql(PPC(shard => $shard), [ "UPDATE campaigns SET geo='0'", where => {geo => '', cid => $cids}]);
    $log->out("campaigns: $rows_count rows updated");
});
$log->out("end.");
