#!/usr/bin/perl

=head1 DEPLOY

# approved by liosha
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "2 минуты",
  comment => 'можно перезапускать',
}

=cut

use Direct::Modern;
use my_inc '..';

use Yandex::DBTools;
use Direct::Campaigns;

use ShardingTools;
use ScriptHelper (log_warn => 1);
use Settings;


my $CHUNK_SIZE = 200;

extract_script_params(
    'cid=i' => \my @only_cids,
);


$log->out('START');

my @shards = ppc_shards();

my %cond_invalid = map {("${_}__is_null" => 1)} qw/strategy_name strategy_data platform/;

SHARD:
for my $shard (@shards) {
    my $min_cid = 0;
    while (1) {
        my $cids = get_one_column_sql(PPC(shard => $shard), [
                "SELECT cid
                FROM campaigns c",
                WHERE => {
                    type => [qw/text geo mobile_content dynamic performance mcb mcbanner/],
                    cid__gt => $min_cid,
                    (@only_cids ? (cid => \@only_cids) : ()),
                    _OR => \%cond_invalid,
                },
                'ORDER BY cid',
                LIMIT => $CHUNK_SIZE,
            ]);
        last if !@$cids;
        $min_cid = $cids->[-1];

        $log->out(sprintf "shard #$shard: going to process %d campaigns (@$cids)", scalar @$cids);

        my %update_camp;
        my $campaigns = Direct::Campaigns->get($cids);
        for my $camp (@{$campaigns->items}) {
            $log->out(sprintf "shard #$shard: cid %d -- %s %s %s",
                $camp->id, $camp->strategy_name, $camp->_strategy_data, $camp->_platform,
            );
            $update_camp{$camp->id} = {
                strategy_name => $camp->strategy_name,
                strategy_data => $camp->_strategy_data,
                platform => $camp->_platform,
            };
        }

        my $updated_camp = do_mass_update_sql(PPC(shard => $shard),
            'campaigns', cid => \%update_camp,
            where => {_OR => \%cond_invalid},
        );
        $log->out("shard #$shard: updated $updated_camp records");
#        use YAML; die Dump \%update;
    }
}

$log->out('FINISH');

