#!/usr/bin/perl

=head1 DEPLOY

# approved by lena-san
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "несколько минут",
}

=cut

=pod

    Калька с 20111215_delete_wrong_rows_from_monitor_db.pl с учетом новых реалий

=cut

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;

use my_inc '..';

use ScriptHelper;
use Settings;
use ShardingTools;

$log->out('START');

for my $shard(ppc_shards()) {
    my $pref_guard = $log->msg_prefix_guard("[shard $shard]");

    $log->out("fetch data");
    my $for_delete = get_all_sql(PPC(shard => $shard), "SELECT cid, MAX(interval_start) AS interval_start FROM when_money_on_camp_was WHERE interval_end >= '2038-01-01 00:00:00' GROUP BY cid HAVING COUNT(*) > 1");

    $log->out("delete wrong rows " . scalar(@$for_delete));
    for my $row (@$for_delete) {
        my $relaxed_guard = relaxed_guard(times => 0.3);
        $log->out($row);
        do_delete_from_table(PPC(shard => $shard), 'when_money_on_camp_was', where => { cid => $row->{cid}, interval_start => $row->{interval_start} });
    }
}

$log->out('FINISH');

