#!/usr/bin/perl

=head1 DEPLOY

# approved by ppalex
# .migr
[
  {
    type => 'sql',
    webstop => 0,
    db => 'ppc:all',
    when => 'after',
    time_estimate => 'менее 10 секунд',
    sql => 'UPDATE mod_mail_candidates SET status="New" WHERE status="Waiting"',
  },
  {
    type => 'script',
    when => 'after',
    time_estimate => "не более 5 минут",
  }
]

=cut

use my_inc '..';
use Direct::Modern;

use Yandex::DBTools;

use ShardingTools;
use ScriptHelper;
use Settings;

my $SELECT_CHUNK_SIZE = 10000;
my $INSERT_CHUNK_SIZE = 2000;

$log->out('START');

for my $shard (ppc_shards()) {
    my $guard = $log->msg_prefix_guard("[SHARD_$shard]");
    $log->out('Start processing shard');

    my $iteration_num = 1;
    while (1) {
        $log->out("Iteration $iteration_num");
        my $absent_data = get_all_sql(PPC(shard => $shard),
            ["SELECT DISTINCT mr.ClientID, mr.cid
                FROM mod_reasons mr
                     LEFT JOIN mod_mail_candidates mmc ON mmc.cid = mr.cid AND mmc.ClientID = mr.ClientID
               WHERE mmc.cid IS NULL and statusSending != 'Yes'
               LIMIT $SELECT_CHUNK_SIZE"]);
        my $data_num = scalar @$absent_data;

        $log->out("Got $data_num ClientID-cid pairs");
        last unless $data_num;

        my @data_to_insert = map {[$_->{ClientID}, $_->{cid}, 'New']} @$absent_data;
        $log->out({insert_data =>\@data_to_insert});
        my $cnt = do_mass_insert_sql(PPC(shard => $shard),
            "INSERT IGNORE mod_mail_candidates (ClientID, cid, status) VALUES %s",
            \@data_to_insert, { max_row_for_insert => $INSERT_CHUNK_SIZE }) + 0;
        $log->out("Inserted $cnt new entries in mod_mail_candidates");

        $iteration_num++;
    }
}

$log->out('FINISH');
