#!/usr/bin/perl

=head1 DEPLOY

# .migr
# approved by ppalex
{
  type => 'script',
  when => 'after',
  time_estimate => "2.5 минуты на devtest",
}

=cut

=pod

    Починка кривых данных для открытых периодов в таблице ppc.when_money_on_camp_was

=cut
use my_inc '..';

use Direct::Modern;

use Yandex::DBTools;
use Yandex::Retry;
use Yandex::ListUtils;

use ScriptHelper;
use Settings;
use ShardingTools;

$log->out( "START" );

for my $shard( ppc_shards() ) {
    my $pref_guard = $log->msg_prefix_guard( "[shard $shard]" );
    my $rows_in_shard_updated = 0;
    $log->out( "fetch data to update" );
    my $for_fix_update = get_one_column_sql( PPC( shard => $shard), "SELECT cid FROM when_money_on_camp_was WHERE interval_end = '2038-01-18 23:00:00'" );
    if(@$for_fix_update){
        $log->out( "Got ".scalar( @$for_fix_update )." wrong rows to update" );
        for my $for_fix_update_chunk ( chunks( \@$for_fix_update, 500 ) ) {
            my $relaxed_guard = relaxed_guard( times => 0.3) ;
            $log->out( sprintf( "Fixing rows for cids: %s" => join( "," => @$for_fix_update_chunk ) ) );
            $rows_in_shard_updated += do_update_table( PPC( shard => $shard ),
                 'when_money_on_camp_was',
                 {interval_end => '2038-01-19'},
                 where => { cid => $for_fix_update_chunk, interval_end => '2038-01-18 23:00:00'}
             );
        }
    }
    $log->out( "Updated ".$rows_in_shard_updated." rows" );
}

$log->out( "FINISH" );

