#!/usr/bin/perl

=head1 DEPLOY

# approved by hmepas
# .migr
{
  type => 'script',
  when => 'after',
  time_estimate => "на devtest: 15 секунд на шард",
  comment => "переотправляет все активные кампании(text, mobile_content) с выключенной опцией
              'Не учитывать предпочтения пользователей'(statusBehavior=No) в БК;
              выставляет всем text/mobile_content кампаниям statusBehavior = Yes. Понимает параметры
               - sleep-coef - какую долю от всей работы должны составлять паузы
               - cid - мультипараметр; позволяет ограничить список обрабатываемых кампаний "
}

=cut

use my_inc '..';
use Yandex::Retry qw/relaxed/;
use Direct::Modern;
use Yandex::DBTools;
use Yandex::ListUtils qw/chunks/;
use Yandex::Validate qw/is_valid_id/;
use ScriptHelper;
use Settings;
use ShardingTools;
use BS::ResyncQueue;

my $BS_RESYNC_PRIORITY = BS::ResyncQueue::PRIORITY_DEFAULT;
my $SLEEP_COEF = 1;
my @ONLY_CIDS;
extract_script_params(
    'sleep-coef' => \$SLEEP_COEF,
    'cid=i@' => \@ONLY_CIDS,
);

sub process_shard {
    my $shard = shift;
    my $camps_info = get_all_sql(PPC(shard => $shard), [
           'SELECT c.cid, c.statusActive FROM campaigns c',
            where => {
                'c.type' => ['text', 'mobile_content'],
                'c.statusBehavior' => 'No',
                (@ONLY_CIDS ? ('c.cid' => \@ONLY_CIDS) : ()),
            }            
        ]);
    $log->out('discovered '.scalar(@{$camps_info})." cids with statusBehavior=No");

    foreach my $chunk_camps (chunks($camps_info, 1000)) {
        my @camps_to_resync = grep { $_->{statusActive} eq 'Yes' } @{$chunk_camps};
        my @cids_to_resync  = map { $_->{cid} } @camps_to_resync;

        my @resync_data = map { {cid => $_, bid => 0, pid => 0, priority => $BS_RESYNC_PRIORITY } } @cids_to_resync;
        
        my @cids_to_update = map { $_->{cid} } @{$chunk_camps};
        relaxed times => $SLEEP_COEF, sub {
                $log->out("about to resync cids".join(",", @cids_to_resync) );
                BS::ResyncQueue::bs_resync(\@resync_data);
                $log->out("finished cids resync");
                $log->out("about to update campaigns cids ".join(",", @cids_to_update) );
                do_sql(PPC(shard => $shard), [
                     "UPDATE campaigns c
                         SET c.statusBehavior = 'Yes'",
                       WHERE => { 'c.cid' => \@cids_to_update }
                ]);
                $log->out("finished campaigns update");
        };
        $log->out("cids updated and scheduled for resync with bs");        
    }
}

$log->out('START');

if (@ONLY_CIDS) {
    for my $cid (@ONLY_CIDS) {
        die "--cid $cid is invalid - value must be positive integer" unless is_valid_id($cid);
    }
}

for my $shard (ppc_shards()) {
    $log->out("about to process shard: $shard");
    my $g = $log->msg_prefix_guard("[shard $shard]");
    process_shard($shard);
    $log->out("finished processing shard: $shard");
}

$log->out('FINISH');

